/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.anttask;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class FindBugsViewerTask
extends Task {
    private static final long DEFAULT_TIMEOUT = -1L;
    private boolean debug = false;
    private File projectFile = null;
    private File loadbugs = null;
    private long timeout = -1L;
    private String jvmargs = "";
    private String look = "native";
    private File homeDir = null;
    private Path classpath = null;
    private Path pluginList = null;
    private Java findbugsEngine = null;

    public void setLoadbugs(File loadbugs) {
        this.loadbugs = loadbugs;
    }

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
    }

    public void setDebug(boolean flag) {
        this.debug = flag;
    }

    public void setJvmargs(String args) {
        this.jvmargs = args;
    }

    public void setLook(String look) {
        this.look = look;
    }

    public void setHome(File homeDir) {
        this.homeDir = homeDir;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Ant.Reference r) {
        this.createClasspath().setRefid((Reference)r);
    }

    public void setPluginList(Path src) {
        if (this.pluginList == null) {
            this.pluginList = src;
        } else {
            this.pluginList.append(src);
        }
    }

    public Path createPluginList() {
        if (this.pluginList == null) {
            this.pluginList = new Path(this.getProject());
        }
        return this.pluginList.createPath();
    }

    public void setPluginListRef(Ant.Reference r) {
        this.createPluginList().setRefid((Reference)r);
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    private void addArg(String arg) {
        this.findbugsEngine.createArg().setValue(arg);
    }

    public void execute() throws BuildException {
        this.findbugsEngine = (Java)this.getProject().createTask("java");
        this.findbugsEngine.setTaskName(this.getTaskName());
        this.findbugsEngine.setFork(true);
        if (this.timeout > 0L) {
            this.findbugsEngine.setTimeout(Long.valueOf(this.timeout));
        }
        if (this.debug) {
            this.jvmargs = this.jvmargs + " -Dfindbugs.debug=true";
        }
        this.findbugsEngine.createJvmarg().setLine(this.jvmargs);
        if (this.homeDir != null) {
            File findbugsLib = new File(this.homeDir, "lib");
            File findbugsLibFindBugs = new File(findbugsLib, "findbugs.jar");
            File findBugsFindBugs = new File(this.homeDir, "findbugs.jar");
            if (findbugsLibFindBugs.exists()) {
                this.findbugsEngine.setClasspath(new Path(this.getProject(), findbugsLibFindBugs.getPath()));
            } else if (findBugsFindBugs.exists()) {
                this.findbugsEngine.setClasspath(new Path(this.getProject(), findBugsFindBugs.getPath()));
            } else {
                throw new IllegalArgumentException("Can't find findbugs.jar in " + this.homeDir);
            }
            this.findbugsEngine.setClassname("edu.umd.cs.findbugs.LaunchAppropriateUI");
            this.findbugsEngine.createJvmarg().setValue("-Dfindbugs.home=" + this.homeDir.getPath());
        } else {
            this.findbugsEngine.setClasspath(this.classpath);
            this.findbugsEngine.setClassname("edu.umd.cs.findbugs.LaunchAppropriateUI");
            this.addArg("-pluginList");
            this.addArg(this.pluginList.toString());
        }
        if (this.projectFile != null) {
            this.addArg("-project");
            this.addArg(this.projectFile.getPath());
        }
        if (this.loadbugs != null) {
            this.addArg("-loadbugs");
            this.addArg(this.loadbugs.getPath());
        }
        if (this.look != null) {
            this.addArg("-look:" + this.look);
        }
        this.log("Launching FindBugs Viewer...");
        int rc = this.findbugsEngine.executeJava();
        if ((rc & 4) != 0) {
            throw new BuildException("Execution of findbugs failed.");
        }
        if ((rc & 2) != 0) {
            this.log("Classes needed for analysis were missing");
        }
    }
}

