/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.obl;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.obl.MatchMethodEntry;
import edu.umd.cs.findbugs.ba.obl.Obligation;
import edu.umd.cs.findbugs.ba.obl.ObligationFactory;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseAction;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseActionType;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseEntry;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseEntryType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.bcel.generic.ReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObligationPolicyDatabase {
    public static final boolean DEBUG = SystemProperties.getBoolean("oa.debug.db");
    private ObligationFactory factory;
    private LinkedList<ObligationPolicyDatabaseEntry> entryList;
    private HashSet<Obligation> allObligations = new HashSet();
    private boolean strictChecking;

    public ObligationPolicyDatabase() {
        this.factory = new ObligationFactory();
        this.entryList = new LinkedList();
    }

    public ObligationFactory getFactory() {
        return this.factory;
    }

    public Set<Obligation> getAllObligations() {
        return this.allObligations;
    }

    public void addEntry(ObligationPolicyDatabaseEntry entry) {
        if (DEBUG) {
            System.out.println("Adding entry " + entry);
        }
        this.allObligations.addAll(entry.getAllObligations());
        this.entryList.add(entry);
    }

    public ObligationPolicyDatabaseEntry addParameterDeletesObligationDatabaseEntry(XMethod xmethod, Obligation obligation, ObligationPolicyDatabaseEntryType entryType) {
        MatchMethodEntry entry = new MatchMethodEntry(xmethod, ObligationPolicyDatabaseActionType.DEL, entryType, obligation);
        this.addEntry(entry);
        return entry;
    }

    public void setStrictChecking(boolean strictChecking) {
        if (DEBUG) {
            System.out.println("Setting strict checking to " + strictChecking);
        }
        this.strictChecking = strictChecking;
    }

    public boolean isStrictChecking() {
        return this.strictChecking;
    }

    public void getActions(ReferenceType receiverType, String methodName, String signature, boolean isStatic, Collection<ObligationPolicyDatabaseAction> actionList) {
        if (DEBUG) {
            System.out.println("Lookup for " + receiverType + "," + methodName + "," + signature + "," + isStatic + ": ");
        }
        for (ObligationPolicyDatabaseEntry entry : this.entryList) {
            boolean matched = entry.getActions(receiverType, methodName, signature, isStatic, actionList);
            if (!DEBUG || !matched) continue;
            System.out.println(" Entry " + entry + "  ==> MATCH");
        }
        if (DEBUG) {
            System.out.println("  ** Resulting action list: " + actionList);
        }
    }

    public List<ObligationPolicyDatabaseEntry> getEntries() {
        return Collections.unmodifiableList(this.entryList);
    }
}

