/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.PluginUpdateListener;
import edu.umd.cs.findbugs.UpdateChecker;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.util.LaunchBrowser;
import edu.umd.cs.findbugs.util.Util;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginUpdateDialog
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(PluginUpdateDialog.class.getName());
    private static final int SOFTWARE_UPDATE_DIALOG_DELAY_MS = 5000;

    public void showUpdateDialog(Collection<UpdateChecker.PluginUpdate> updates, boolean force) {
        ArrayList<UpdateChecker.PluginUpdate> sortedUpdates = new ArrayList<UpdateChecker.PluginUpdate>();
        UpdateChecker.PluginUpdate core = this.sortUpdates(updates, sortedUpdates);
        if (this.updatesHaveBeenSeenBefore(sortedUpdates) && !force) {
            return;
        }
        String headline = core != null && updates.size() >= 2 ? "FindBugs and some plugins have updates" : (updates.isEmpty() ? "FindBugs and all plugins are up to date!" : (core == null ? "Some FindBugs plugins have updates" : null));
        JPanel comp = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridwidth = 3;
        gbc.fill = 1;
        if (headline != null) {
            JLabel headlineLabel = new JLabel(headline);
            headlineLabel.setFont(headlineLabel.getFont().deriveFont(1, 24.0f));
            comp.add((Component)headlineLabel, gbc);
        }
        if (!updates.isEmpty()) {
            int i = 1;
            for (UpdateChecker.PluginUpdate update : sortedUpdates) {
                String msg;
                gbc.gridy = ++i;
                gbc.gridx = 1;
                gbc.fill = 1;
                gbc.gridwidth = 1;
                gbc.weightx = 1.0;
                JLabel label = this.createPluginLabel(update);
                comp.add((Component)label, gbc);
                gbc.weightx = 0.0;
                gbc.gridx = 2;
                if (update.getUrl() != null && update.getUrl().length() > 0) {
                    JButton button = this.createPluginUpdateButton(comp, update);
                    comp.add((Component)button, gbc);
                }
                if ((msg = update.getMessage()) == null || msg.length() <= 0) continue;
                gbc.gridx = 1;
                gbc.gridwidth = 3;
                gbc.weightx = 1.0;
                gbc.fill = 1;
                gbc.gridy = ++i;
                JTextPane msgpane = this.createMessagePane(msg);
                comp.add((Component)msgpane, gbc);
            }
        }
        JOptionPane.showMessageDialog(null, comp, "Software Updates", 1);
    }

    private JTextPane createMessagePane(String msg) {
        JTextPane msgpane = new JTextPane();
        msgpane.setEditable(false);
        msgpane.setFocusable(false);
        msgpane.setText(msg);
        return msgpane;
    }

    private JLabel createPluginLabel(UpdateChecker.PluginUpdate update) {
        String name = update.getPlugin().isCorePlugin() ? "FindBugs" : update.getPlugin().getShortDescription();
        JLabel label = new JLabel(MessageFormat.format("<html><b>{0} {2}</b> is available<br><i><small>(currently installed: {1})", name, update.getPlugin().getVersion(), update.getVersion()));
        label.setFont(label.getFont().deriveFont(0, label.getFont().getSize() + 4));
        return label;
    }

    private boolean updatesHaveBeenSeenBefore(List<UpdateChecker.PluginUpdate> sortedUpdates) {
        String newHash;
        Preferences prefs = Preferences.userNodeForPackage(MainFrame.class);
        String oldHash = prefs.get("last-plugin-update-hash", "");
        if (oldHash.equals(newHash = this.buildPluginUpdateHash(sortedUpdates))) {
            LOGGER.fine("Skipping update dialog because these updates have been seen before");
            return true;
        }
        prefs.put("last-plugin-update-hash", newHash);
        return false;
    }

    public PluginUpdateListener createListener() {
        return new MyPluginUpdateListener();
    }

    private String buildPluginUpdateHash(Collection<UpdateChecker.PluginUpdate> updates) {
        StringBuilder builder = new StringBuilder();
        for (UpdateChecker.PluginUpdate update : updates) {
            builder.append(update.getPlugin().getPluginId());
            builder.append(update.getVersion());
        }
        return builder.toString();
    }

    private JButton createPluginUpdateButton(final JPanel comp, final UpdateChecker.PluginUpdate update) {
        JButton button = new JButton("<html><u><font color=#0000ff>More info...");
        button.setBorderPainted(false);
        button.setOpaque(false);
        button.setContentAreaFilled(false);
        button.setBackground(comp.getBackground());
        button.setToolTipText(update.getUrl());
        button.setCursor(Cursor.getPredefinedCursor(12));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean failed;
                try {
                    failed = !LaunchBrowser.showDocument(new URL(update.getUrl()));
                }
                catch (MalformedURLException e1) {
                    failed = true;
                }
                if (failed) {
                    JOptionPane.showMessageDialog(comp, "Could not open URL " + update.getUrl());
                }
            }
        });
        return button;
    }

    private UpdateChecker.PluginUpdate sortUpdates(Collection<UpdateChecker.PluginUpdate> updates, List<UpdateChecker.PluginUpdate> updates2) {
        UpdateChecker.PluginUpdate core = null;
        for (UpdateChecker.PluginUpdate update : updates) {
            if (update.getPlugin().isCorePlugin()) {
                core = update;
                continue;
            }
            updates2.add(update);
        }
        Collections.sort(updates2, new Comparator<UpdateChecker.PluginUpdate>(){

            @Override
            public int compare(UpdateChecker.PluginUpdate o1, UpdateChecker.PluginUpdate o2) {
                return o1.getPlugin().getShortDescription().compareTo(o2.getPlugin().getShortDescription());
            }
        });
        if (core != null) {
            updates2.add(0, core);
        }
        return core;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyPluginUpdateListener
    implements PluginUpdateListener {
        private MyPluginUpdateListener() {
        }

        @Override
        public void pluginUpdateCheckComplete(final Collection<UpdateChecker.PluginUpdate> updates, final boolean force) {
            if (updates.isEmpty() && !force) {
                return;
            }
            if (force) {
                this.showUpdateDialogInSwingThread(updates, force);
            } else {
                Util.runInDameonThread(new Runnable(){

                    public void run() {
                        try {
                            Thread.sleep(5000L);
                            MyPluginUpdateListener.this.showUpdateDialogInSwingThread(updates, force);
                        }
                        catch (InterruptedException e) {
                            LOGGER.log(Level.FINE, "Software update dialog thread interrupted", e);
                        }
                    }
                }, "Software Update Dialog");
            }
        }

        private void showUpdateDialogInSwingThread(final Collection<UpdateChecker.PluginUpdate> updates, final boolean force) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PluginUpdateDialog.this.showUpdateDialog(updates, force);
                }
            });
        }
    }
}

