/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.sourceViewer;

import java.text.CharacterIterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;

public class DocumentCharacterIterator
implements CharacterIterator {
    private final Document doc;
    private final Segment text;
    private int docPos = 0;
    private int segmentEnd;

    DocumentCharacterIterator(Document doc) {
        this.doc = doc;
        this.text = new Segment();
        this.text.setPartialReturn(true);
        try {
            doc.getText(0, doc.getLength(), this.text);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        this.segmentEnd = this.text.count;
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }

    public char current() {
        return this.text.current();
    }

    public char first() {
        throw new UnsupportedOperationException();
    }

    public int getBeginIndex() {
        throw new UnsupportedOperationException();
    }

    public int getEndIndex() {
        throw new UnsupportedOperationException();
    }

    public int getIndex() {
        return this.docPos;
    }

    public char last() {
        throw new UnsupportedOperationException();
    }

    public char next() {
        ++this.docPos;
        if (this.docPos < this.segmentEnd || this.segmentEnd >= this.doc.getLength()) {
            return this.text.next();
        }
        try {
            this.doc.getText(this.segmentEnd, this.doc.getLength() - this.segmentEnd, this.text);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        this.segmentEnd += this.text.count;
        return this.text.current();
    }

    public char previous() {
        throw new UnsupportedOperationException();
    }

    public char setIndex(int position) {
        throw new UnsupportedOperationException();
    }
}

