/*
 * Decompiled with CFR 0.152.
 */
package junitx.framework;

import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Assert;

public class ArrayAssert {
    private ArrayAssert() {
    }

    public static void assertEquals(String message, Object[] expected, Object[] actual) {
        if (Arrays.equals(expected, actual)) {
            return;
        }
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.assertNotNull((String)(formatted + "expected array: <not null> but was <null>"), (Object)expected);
        Assert.assertNotNull((String)(formatted + "expected array: <null> but was <not null>"), (Object)actual);
        Assert.assertEquals((String)(formatted + "[array length] "), (int)expected.length, (int)actual.length);
        int i = 0;
        while (i < expected.length) {
            Assert.assertEquals((String)(formatted + "[position " + i + "]"), (Object)expected[i], (Object)actual[i]);
            ++i;
        }
    }

    public static void assertEquals(Object[] expected, Object[] actual) {
        ArrayAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(double[] expected, double[] actual, double delta) {
        ArrayAssert.assertEquals(null, expected, actual, delta);
    }

    public static void assertEquals(String message, double[] expected, double[] actual, double delta) {
        if (Arrays.equals(expected, actual)) {
            return;
        }
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.assertNotNull((String)(formatted + "expected array: <not null> but was <null>"), (Object)expected);
        Assert.assertNotNull((String)(formatted + "expected array: <null> but was <not null>"), (Object)actual);
        Assert.assertEquals((String)(formatted + "[array length] "), (int)expected.length, (int)actual.length);
        int i = 0;
        while (i < actual.length) {
            Assert.assertEquals((String)(formatted + "[position " + i + "]"), (double)expected[i], (double)actual[i], (double)delta);
            ++i;
        }
    }

    public static void assertEquals(String message, float[] expected, float[] actual, float delta) {
        if (Arrays.equals(expected, actual)) {
            return;
        }
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.assertNotNull((String)(formatted + "expected array: <not null> but was <null>"), (Object)expected);
        Assert.assertNotNull((String)(formatted + "expected array: <null> but was <not null>"), (Object)actual);
        Assert.assertEquals((String)(formatted + "[array length] "), (int)expected.length, (int)actual.length);
        int i = 0;
        while (i < actual.length) {
            Assert.assertEquals((String)(formatted + "[position " + i + "]"), (float)expected[i], (float)actual[i], (float)delta);
            ++i;
        }
    }

    public static void assertEquals(float[] expected, float[] actual, float delta) {
        ArrayAssert.assertEquals(null, expected, actual, delta);
    }

    public static void assertEquals(String message, long[] expected, long[] actual) {
        if (Arrays.equals(expected, actual)) {
            return;
        }
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.assertNotNull((String)(formatted + "expected array: <not null> but was <null>"), (Object)expected);
        Assert.assertNotNull((String)(formatted + "expected array: <null> but was <not null>"), (Object)actual);
        Assert.assertEquals((String)(formatted + "[array length] "), (int)expected.length, (int)actual.length);
        int i = 0;
        while (i < actual.length) {
            Assert.assertEquals((String)(formatted + "[position " + i + "]"), (long)expected[i], (long)actual[i]);
            ++i;
        }
    }

    public static void assertEquals(long[] expected, long[] actual) {
        ArrayAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, int[] expected, int[] actual) {
        if (Arrays.equals(expected, actual)) {
            return;
        }
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.assertNotNull((String)(formatted + "expected array: <not null> but was <null>"), (Object)expected);
        Assert.assertNotNull((String)(formatted + "expected array: <null> but was <not null>"), (Object)actual);
        Assert.assertEquals((String)(formatted + "[array length] "), (int)expected.length, (int)actual.length);
        int i = 0;
        while (i < actual.length) {
            Assert.assertEquals((String)(formatted + "[position " + i + "]"), (int)expected[i], (int)actual[i]);
            ++i;
        }
    }

    public static void assertEquals(int[] expected, int[] actual) {
        ArrayAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, short[] expected, short[] actual) {
        if (Arrays.equals(expected, actual)) {
            return;
        }
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.assertNotNull((String)(formatted + "expected array: <not null> but was <null>"), (Object)expected);
        Assert.assertNotNull((String)(formatted + "expected array: <null> but was <not null>"), (Object)actual);
        Assert.assertEquals((String)(formatted + "[array length] "), (int)expected.length, (int)actual.length);
        int i = 0;
        while (i < actual.length) {
            Assert.assertEquals((String)(formatted + "[position " + i + "]"), (short)expected[i], (short)actual[i]);
            ++i;
        }
    }

    public static void assertEquals(short[] expected, short[] actual) {
        ArrayAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, char[] expected, char[] actual) {
        if (Arrays.equals(expected, actual)) {
            return;
        }
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.assertNotNull((String)(formatted + "expected array: <not null> but was <null>"), (Object)expected);
        Assert.assertNotNull((String)(formatted + "expected array: <null> but was <not null>"), (Object)actual);
        Assert.assertEquals((String)(formatted + "[array length] "), (int)expected.length, (int)actual.length);
        int i = 0;
        while (i < actual.length) {
            Assert.assertEquals((String)(formatted + "[position " + i + "]"), (char)expected[i], (char)actual[i]);
            ++i;
        }
    }

    public static void assertEquals(char[] expected, char[] actual) {
        ArrayAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, boolean[] expected, boolean[] actual) {
        if (Arrays.equals(expected, actual)) {
            return;
        }
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.assertNotNull((String)(formatted + "expected array: <not null> but was <null>"), (Object)expected);
        Assert.assertNotNull((String)(formatted + "expected array: <null> but was <not null>"), (Object)actual);
        Assert.assertEquals((String)(formatted + "[array length] "), (int)expected.length, (int)actual.length);
        int i = 0;
        while (i < actual.length) {
            Assert.assertEquals((String)(formatted + "[position " + i + "]"), (boolean)expected[i], (boolean)actual[i]);
            ++i;
        }
    }

    public static void assertEquals(boolean[] expected, boolean[] actual) {
        ArrayAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, byte[] expected, byte[] actual) {
        if (Arrays.equals(expected, actual)) {
            return;
        }
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.assertNotNull((String)(formatted + "expected array: <not null> but was <null>"), (Object)expected);
        Assert.assertNotNull((String)(formatted + "expected array: <null> but was <not null>"), (Object)actual);
        Assert.assertEquals((String)(formatted + "[array length] "), (int)expected.length, (int)actual.length);
        int i = 0;
        while (i < actual.length) {
            Assert.assertEquals((String)(formatted + "[position " + i + "]"), (byte)expected[i], (byte)actual[i]);
            ++i;
        }
    }

    public static void assertEquals(byte[] expected, byte[] actual) {
        ArrayAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquivalenceArrays(String message, Object[] expected, Object[] actual) {
        if (Arrays.equals(expected, actual)) {
            return;
        }
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.assertNotNull((String)(formatted + "expected array: <not null> but was <null>"), (Object)expected);
        Assert.assertNotNull((String)(formatted + "expected array: <null> but was <not null>"), (Object)actual);
        ArrayList<Object> missing = new ArrayList<Object>();
        int i = 0;
        while (i < expected.length) {
            missing.add(expected[i]);
            ++i;
        }
        ArrayList<Object> extra = new ArrayList<Object>();
        int i2 = 0;
        while (i2 < actual.length) {
            extra.add(actual[i2]);
            ++i2;
        }
        ArrayList missingClone = (ArrayList)missing.clone();
        missing.removeAll(extra);
        extra.removeAll(missingClone);
        Assert.assertTrue((String)(formatted + "[Missing elements: " + missing + "]"), (missing.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)(formatted + "[Extra elements: " + extra + "]"), (extra.size() == 0 ? 1 : 0) != 0);
    }

    public static void assertEquivalenceArrays(Object[] expected, Object[] actual) {
        ArrayAssert.assertEquivalenceArrays(null, expected, actual);
    }
}

