//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.genericevents.commands;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import de.ugoe.cs.autoquest.CommandHelpers;
import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.eventcore.IHierarchicalEventTargetModel;
import de.ugoe.cs.autoquest.plugin.genericevents.GenericEventLogParser;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command to parse a file with sessions generated by the generic event monitor.
 * </p>
 * 
 * @author Patrick Harms
 * @version 1.0
 */
public class CMDparseGenericEvents implements Command {

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#run(java.util.List)
     */
    @Override
    public void run(List<Object> parameters) {
        String filename = null;
        String sequencesName = null;

        Set<String> ignoredEvents = new HashSet<>();
        
        try {
            for (int i = 0; i < parameters.size(); i++) {
                String param = (String) parameters.get(i);
                if (filename == null) {
                    filename = param;
                }
                else if (sequencesName == null) {
                    sequencesName = param;
                }
                else {
                    ignoredEvents.add(param);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("illegal parameters provided: " + e);
        }

        if (sequencesName == null) {
            sequencesName = "sequences";
        }

        GenericEventLogParser parser = new GenericEventLogParser(ignoredEvents);

        try {
            parser.parseFile(filename);
        }
        catch (Exception e) {
            Console.printerrln("Could not parse " + filename + ": " + e.getMessage());
            return;
        }

        Collection<List<Event>> sequences = parser.getSequences();

        IHierarchicalEventTargetModel<?> targets = parser.getHierarchicalEventTargetModel();

        if (GlobalDataContainer.getInstance().addData(sequencesName, sequences)) {
            CommandHelpers.dataOverwritten(sequencesName);
        }

        if (GlobalDataContainer.getInstance().addData(sequencesName + "_targets", targets)) {
            CommandHelpers.dataOverwritten(sequencesName + "_targets");
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#help()
     */
    @Override
    public String help() {
        return "parseGenericEvents <filename> [<sequencesName>] [<ignoredEventType>*] [<ignoredEventType.ignoredEventTargetId>*]";
    }

}
