#include "StdAfx.h"
#include "TestResults.h"

TestResults::TestResults(_TCHAR * replayFile) : replayFile(replayFile)
{
}

TestResults::~TestResults(void)
{
}


void TestResults::addResult(std::wstring sessionId, RESULT result)
{
	results.push_back(std::pair<std::wstring, RESULT>(sessionId, result));
}


void TestResults::write(_TCHAR * resultFile) {
	std::wofstream file(resultFile, std::ios_base::trunc);

	file << "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" << std::endl; // TODO check encoding
	file << "<results file=\"" << replayFile << "\">" << std::endl;
	for( size_t i=0; i<results.size() ; i++ ) {
		RESULT & result = results[i].second;
		file << "  <session id=\"" << results[i].first << "\" verdict=\"";
		if( result.sessionPass==true ) {
			file << "pass\"/>" << std::endl;
		} else {
			file << "fail\">"; // TODO
			file << "    <details msgNo=\"" << result.msgNumber << "\" errMsg=\"" << result.errorMessage << "\"/>" << std::endl;
			file << "  </session>" << std::endl;
		}
	}
	file << "</results>" << std::endl;
	file.flush();
	file.close();
}