#!/bin/bash

#   Copyright 2012 Georg-August-Universit�t G�ttingen, Germany
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.



# This script checks if the autoquest-generic-event-monitor, which is in the same folder as
# this script, is running


# Absolute path to this script, e.g. /home/user/bin/stop.sh
SCRIPT=$(readlink -f $0)

# Find the autoquest-htmlmonitor JAR-File and start in the Folder of this Script
JAR_FILE=`find $(dirname $SCRIPT) -type f -name 'autoquest-generic-event-monitor-*.jar'`

# Get the ProcessID of the autoquest-generic-event-monitor which is in the same folder as this script
PID=$(ps ax | grep "$JAR_FILE" | grep -v ' grep ' | awk '{print $1}')

if [ -z "$PID" ]; then
  echo "autoquest-generic-event-monitor is not running"
else
  echo "autoquest-generic-event-monitor is running with PID: $PID"
fi

