//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore.guimodel;

import de.ugoe.cs.autoquest.eventcore.IEventTargetSpec;
import de.ugoe.cs.autoquest.eventcore.IHierarchicalEventTarget;
import de.ugoe.cs.autoquest.eventcore.IHierarchicalEventTargetModel;

public class MockGUIElement implements IGUIElement {
    
    /**  */
    private static final long serialVersionUID = 1L;
    
    MockGUIElementSpec spec;
    
    IGUIElement parent;
    
    public MockGUIElement(MockGUIElementSpec spec, IGUIElement parent){
        this.spec = spec;
        this.parent = parent;
    }

    @Override
    public String getPlatform() {
        return null;
    }

    @Override
    public String getStringIdentifier() {
        return null;
    }

    @Override
    public IGUIElementSpec getSpecification() {
        return spec;
    }

    @Override
    public IGUIElement getParent() {
        return parent;
    }

    @Override
    public GUIModel getGUIModel() {
        return null;
    }

    @Override
    public void updateSpecification(IEventTargetSpec furtherSpec) { }

    @Override
    public IHierarchicalEventTargetModel<?> getEventTargetModel() {
        return null;
    }

    @Override
    public void addEqualEventTarget(IHierarchicalEventTarget equalElement) { }

    @Override
    public IGUIView getView() {
        return null;
    }

    @Override
    public double getDistanceTo(IGUIElement otherElement) {
        return 0.0;
    }

    @Override
    public boolean isUsed() {
        return false;
    }

    @Override
    public void markUsed() { }

}
