//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore;

import java.io.Serializable;

/**
 * <p>
 * Common interface for event targets. An event target can, e.g., be an element of a GUI or Web
 * server or VR. A concrete event-driven software platform can define its event targets through the
 * implementation of this interface.
 * </p>
 * 
 * @version 1.0
 * @author Steffen Herbold
 */
public interface IEventTarget extends Serializable {

    /**
     * <p>
     * Returns the name of event-driven software platform to which the target belongs.
     * </p>
     * 
     * @return name of the platform
     */
    public String getPlatform();

    /**
     * <p>
     * Returns a string identifier of the target. This is very convenient for visualizations of
     * events.
     * </p>
     * 
     * @return target identifier
     */
    public String getStringIdentifier();

}
