//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore;

import java.io.Serializable;

/**
 * <p>
 * Common interface for event target specifications.
 * </p>
 * 
 * @version 1.1
 * @author Patrick Harms, Steffen Herbold
 */
public interface IEventTargetSpec extends Serializable {

    /**
     * <p>
     * Evaluates if two event target specifications are similar. Similar means that a heuristic
     * determines that the two event target specifications describe the same event target.
     * </p>
     * 
     * @param other
     *            specification whose similarity to this is evaluated
     *            
     * @return true if the specifications are similar; false otherwise
     */
    public boolean getSimilarity(IEventTargetSpec other);

    /**
     * <p>
     * Defines that {@link IEventTargetSpec} implementations have to define equals.
     * </p>
     * 
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object other);

    /**
     * <p>
     * Defines that {@link IEventTargetSpec} implementations have to define hashCode.
     * </p>
     * 
     * @see Object#hashCode()
     */
    @Override
    public int hashCode();
}
