//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 16.07.2012$
 * @author 2012, last modified by $Author: pharms$
 */
public class UsabilityEvaluationResult implements Serializable {
    
    /**  */
    private static final long serialVersionUID = 1L;

    /** */
    private ITaskModel taskModel;
    
    /** */
    private List<UsabilitySmell> smells = new ArrayList<UsabilitySmell>();

    /**
     *
     */
    public UsabilityEvaluationResult(ITaskModel taskModel) {
        this.taskModel = taskModel;
    }

    /**
     *
     */
    public UsabilityEvaluationResult(ITaskModel                 taskModel,
                                     Collection<UsabilitySmell> smells)
    {
        this.taskModel = taskModel;
        for (UsabilitySmell smell : smells) {
            this.smells.add(smell);
        }
    }

    /**
     *
     */
    public UsabilityEvaluationResult(ITaskModel                      taskModel,
                                     List<UsabilityEvaluationResult> results)
    {
        this.taskModel = taskModel;
        for (UsabilityEvaluationResult result : results) {
            for (UsabilitySmell smell : result.getAllSmells()) {
                smells.add(smell);
            }
        }
    }

    /**
     *
     */
    public void addSmell(UsabilitySmellIntensity   intensity,
                         UsabilitySmellDescription description,
                         Map<String, Object>       parameters)
    {
        addSmell(null, intensity, description, parameters);
    }

    /**
     *
     */
    public void addSmell(ITask                     smellingTask,
                         UsabilitySmellIntensity   intensity,
                         UsabilitySmellDescription description,
                         Map<String, Object>       parameters)
    {
        smells.add(new UsabilitySmell(smellingTask, intensity, description, parameters));
    }

    /**
     *
     */
    public List<UsabilitySmell> getAllSmells() {
        return smells;
    }

    /**
     * @return the taskModel
     */
    public ITaskModel getTaskModel() {
        return taskModel;
    }

}
