//   Copyright 2015 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.genericevents.eventCore;

import java.util.HashMap;
import java.util.Map;

import de.ugoe.cs.autoquest.eventcore.IEventTargetSpec;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
public class GenericEventTargetSpec implements IEventTargetSpec {

    /**  */
    private static final long serialVersionUID = 1L;
    
    /** */
    private Map<String, String> targetParameters;

    /** */
    private String targetId;
    
    /** */
    private String name;

    /**
     *
     */
    public GenericEventTargetSpec(String id, Map<String, String> parameters) {
        this.targetId = id;
        this.targetParameters = parameters;
        
        name = parameters.get("name");
        
        if (name == null) {
            name = targetId;
        }
    }

    /* (non-Javadoc)
     * @see IEventTargetSpec#getSimilarity(IEventTargetSpec)
     */
    @Override
    public boolean getSimilarity(IEventTargetSpec other) {
        if (this == other) {
            return true;
        }
        else if (other instanceof GenericEventTargetSpec) {
            Map<String, String> otherParameters = ((GenericEventTargetSpec) other).targetParameters;
            
            if (targetParameters == null) {
                return otherParameters == null;
            }
            else if (otherParameters == null) {
                return false;
            }
            else if (targetParameters.size() != otherParameters.size()) {
                return false;
            }
            else {
                for (Map.Entry<String, String> entry : targetParameters.entrySet()) {
                    String otherValue = otherParameters.get(entry.getKey());
                    if ((otherValue != entry.getValue()) &&
                        ((otherValue == null) || (!otherValue.equals(entry.getValue()))))
                    {
                        return false;
                    }
                }
                return true;
            }
            
        }
        else {
            return false;
        }
    }

    /**
     * 
     *
     * @return
     */
    public String getId() {
        return targetId;
    }

    /**
     *
     */
    public void mergeWith(GenericEventTargetSpec furtherSpec) {
        if (furtherSpec.targetParameters != null) {
            if (targetParameters == null) {
                targetParameters = new HashMap<>(furtherSpec.targetParameters);
            }
            else {
                targetParameters.putAll(furtherSpec.targetParameters);
            }
        }
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return name;
    }

}
