//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore.guimodel;

import de.ugoe.cs.autoquest.eventcore.HierarchicalEventTargetTree;
import de.ugoe.cs.autoquest.eventcore.guimodel.GUIElementFactory;
import de.ugoe.cs.autoquest.eventcore.guimodel.GUIModel;

/**
 * <p>
 * This class provides the interfaces for GUI element trees.
 * </p>
 * <p>
 * The GUIElementTree represents the hierarchical structure of the GUI elements "as it is"
 * currently during a session. It may change during the session due to creation and destruction
 * of GUI elements. The parameter T represents the id type of the GUI elements that are handled
 * internally.
 * </p>
 * 
 * @author Fabian Glaser
 * @author Steffen Herbold
 * @version 1.0
 */
public class GUIElementTree<T> extends HierarchicalEventTargetTree<T, IGUIElement, IGUIElementSpec>
{

    /**
     * <p>
     * Creates a new GUIElementTree.
     * </p>
     */
    public GUIElementTree() {
        this(new GUIModel());
    }
    
    /**
     * <p>
     * Creates a GUIElementTree with an already existing guiModel
     * @param guiModel
     * </p>
     */
    public GUIElementTree(GUIModel guiModel){
        super(guiModel, GUIElementFactory.getInstance());
    }

    /**
     * @return the guiModel
     */
    public GUIModel getGUIModel() {
        return (GUIModel) super.getHierarchicalEventTargetModel();
    }

}
