//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore.guimodel;

import de.ugoe.cs.autoquest.eventcore.IEventTargetSpec;

public class MockGUIElementSpec implements IGUIElementSpec {

    /**  */
    private static final long serialVersionUID = 1L;

    @Override
    public String getType() {
        return "dummy";
    }

    @Override
    public String[] getTypeHierarchy() {
        return new String[]{getType()};
    }

    @Override
    public boolean getSimilarity(IEventTargetSpec other) {
        return false;
    }

}
