//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.jfc.commands;

import java.util.Collection;
import java.util.List;

import de.ugoe.cs.autoquest.CommandHelpers;
import de.ugoe.cs.autoquest.SequenceInstanceOf;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.plugin.jfc.JFCJacaretoReplayGenerator;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command to create a Jacareto xml replay file from stored sessions.
 * </p>
 * 
 * @author Daniel May
 * @version 1.0
 */
public class CMDgenerateJacaretoReplay implements Command {

    @Override
    public String help() {
        return "generateJacaretoReplay <filename> <sequences> <class> <basepath> <classpathext> {<menufile>}";
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#run(java.util.List)
     */
    @SuppressWarnings("unchecked")
    @Override
    public void run(List<Object> parameters) {
        String filename;
        String sequencesName;
        String classpath;
        String basepath;
        String classpathext;
        String menu = "";
        try {
            filename = (String) parameters.get(0);
            sequencesName = (String) parameters.get(1);
            classpath = (String) parameters.get(2);
            basepath = (String) parameters.get(3);
            classpathext = (String) parameters.get(4);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }

        if (parameters.size() > 5) {
            menu = (String) parameters.get(5);
        }

        Collection<List<Event>> sequences = null;
        Object dataObject = GlobalDataContainer.getInstance().getData(sequencesName);
        if (dataObject == null) {
            CommandHelpers.objectNotFoundMessage(sequencesName);
            return;
        }
        if (!SequenceInstanceOf.isCollectionOfSequences(dataObject)) {
            CommandHelpers.objectNotType(sequencesName, "Collection<List<Event<?>>>");
            return;
        }

        sequences = (Collection<List<Event>>) dataObject;

        int index = 1;
        for (List<Event> sequence : sequences) {
            JFCJacaretoReplayGenerator generator =
                new JFCJacaretoReplayGenerator(sequence, filename + "_" + index, classpath,
                                               basepath, classpathext, menu);
            generator.writeJacaretoXML();
            index++;
        }
    }
}
