//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.ui.swt;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.eventcore.IHierarchicalEventTargetModel;

public class InsertAssertionDialog extends Dialog {

    protected Event result;
    protected Shell shell;

    private TabFolder tabFolder;

    List<AbstractInsertEventComposite> insertEventComposites;
    IHierarchicalEventTargetModel<?> eventTargetModel;

    /**
     * Create the dialog.
     * 
     * @param parent
     * @param style
     */
    public InsertAssertionDialog(Shell parent, int style, IHierarchicalEventTargetModel<?> eventTargetModel) {
        super(parent, style);
        setText("SWT Dialog");
        this.eventTargetModel = eventTargetModel;
    }

    /**
     * Open the dialog.
     * 
     * @return the result
     */
    public Event open() {
        result = null;
        insertEventComposites = new ArrayList<AbstractInsertEventComposite>();
        createContents();
        shell.open();
        shell.layout();
        Display display = getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (!display.readAndDispatch()) {
                display.sleep();
            }
        }
        return result;
    }

    /**
     * Create contents of the dialog.
     */
    private void createContents() {
        shell = new Shell(getParent(), SWT.SHELL_TRIM | SWT.BORDER | SWT.APPLICATION_MODAL);
        shell.setSize(450, 300);
        shell.setText(getText());
        shell.setLayout(new GridLayout(2, false));

        tabFolder = new TabFolder(shell, SWT.NONE);
        tabFolder.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));

        TabItem tbtmTextEquals = new TabItem(tabFolder, SWT.NONE);
        tbtmTextEquals.setText("TextEquals");
        AbstractInsertEventComposite compTextEquals =
            new InsertTextEquals(tabFolder, SWT.NO_BACKGROUND, eventTargetModel);
        tbtmTextEquals.setControl(compTextEquals);
        insertEventComposites.add(compTextEquals);

        TabItem tbtmFileEquals = new TabItem(tabFolder, SWT.NONE);
        tbtmFileEquals.setText("FileEquals");
        AbstractInsertEventComposite compFileEquals =
            new InsertFileEquals(tabFolder, SWT.NO_BACKGROUND, eventTargetModel);
        tbtmFileEquals.setControl(compFileEquals);
        insertEventComposites.add(compFileEquals);

        Button btnInsert = new Button(shell, SWT.NONE);
        btnInsert.setText("Insert");
        btnInsert.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                int index = tabFolder.getSelectionIndex();
                result = insertEventComposites.get(index).getEvent();
                shell.dispose();
            }
        });

        Button btnAbort = new Button(shell, SWT.NONE);
        btnAbort.setText("Abort");
        btnAbort.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                shell.dispose();
            }
        });
    }
}
