//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.ui.swt;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;

import de.ugoe.cs.autoquest.assertions.FileEqualsAssertEventType;
import de.ugoe.cs.autoquest.assertions.FileEqualsReplay;
import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.eventcore.IHierarchicalEventTargetModel;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

public class InsertFileEquals extends AbstractInsertEventComposite {
    private Text actualText;
    private Text expectedText;

    public InsertFileEquals(Composite parent, int style) {
        this(parent, style, null);
    }

    /**
     * Create the composite.
     * 
     * @param parent
     * @param style
     */
    public InsertFileEquals(Composite parent, int style, IHierarchicalEventTargetModel<?> eventTargetModel) {
        super(parent, style, eventTargetModel);
        setLayout(new GridLayout(3, false));

        Label lblExpectedFile = new Label(this, SWT.NONE);
        lblExpectedFile.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
        lblExpectedFile.setText("Expected file:");

        expectedText = new Text(this, SWT.BORDER);
        expectedText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

        Button btnSearch = new Button(this, SWT.NONE);
        btnSearch.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(getShell(), SWT.OPEN);
                String filename = fileDialog.open();
                if (filename != null) {
                    expectedText.setText(filename);
                }
            }
        });
        btnSearch.setText("Search...");

        Label lblActualFile = new Label(this, SWT.NONE);

        lblActualFile.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
        lblActualFile.setText("Actual file:");

        actualText = new Text(this, SWT.BORDER);
        actualText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
        new Label(this, SWT.NONE);

    }

    @Override
    protected void checkSubclass() {
        // Disable the check that prevents subclassing of SWT components
    }

    @Override
    public Event getEvent() {
        FileEqualsReplay replay =
            new FileEqualsReplay(expectedText.getText(), actualText.getText());
        Event event = new Event(new FileEqualsAssertEventType());
        event.addReplayable(replay);
        return event;
    }

}
