//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore.gui;

/**
 * <p>
 * Event type for scrolling. The target of the respective event was scrolled.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public class Scroll implements IInteraction {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;
    
    /**
     * <p>
     * the x position to which was scrolled
     * </p>
     */
    private int x;

    /**
     * <p>
     * the y position to which was scrolled
     * </p>
     */
    private int y;

    /**
     * <p>
     * initializes a scrolling with the position the user scrolled to
     * <p>
     * 
     * @param x  the position on the x axis to which the user scrolled
     * @param y  the position on the y axis to which the user scrolled
     */
    public Scroll(int x, int y) {
        this.x = x;
        this.y = y;
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#getName()
     */
    public String getName() {
        return "Scroll";
    }

    /**
     * @return the position
     */
    public int getXPosition() {
        return x;
    }

    /**
     * @return the y position
     */
    public int getYPosition() {
        return y;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "scroll(" + x + "," + y + ")";
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Scroll) {
            return (((Scroll) obj).x == x) && (((Scroll) obj).y == y);
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return getClass().hashCode();
    }

}
