//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore.gui;

/**
 * <p>
 * Event type for a single touch events, i.e. touch on a mobile phone.
 * </p>
 * 
 * @version 1.0
 * @author Florian Unger
 */
public class TouchSingle extends TouchInteraction {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * The x coordinate of the touched view in time of touch.
     * </p>
     */
    /*
     * (non-Javadoc)
     * 
     * @see android.view.View#getX()
     * http://developer.android.com/reference/android/view/View.html#getX()
     */
    private float x;

    /**
     * <p>
     * The y coordinate of the touched view in time of touch.
     * </p>
     */
    /*
     * (non-Javadoc)
     * 
     * @see android.view.View#getY()
     * http://developer.android.com/reference/android/view/View.html#getY()
     */
    private float y;

    /**
     * <p>
     * Constructor. Creates a new {@link TouchSingle} event type.
     * </p>
     */
    public TouchSingle(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public String getName() {
        return "TouchSingle";
    }

    /**
     * @return the x position of the touched view in time of touch
     */
    public float getX() {
        return x;
    }

    /**
     * @return the y position of the touched view in time of touch
     */
    public float getY() {
        return y;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if(obj == this){
            return true;
        }
        if(!(obj instanceof TouchSingle)){
            return false;
        }
        TouchSingle touch = (TouchSingle)obj;
        return touch.getX() == x && touch.getY() == y;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        // 17 due to the reason that this is a prime number.
        int result = 17;
        /*
         * 31 due to the reason that a lot of VM's could optimize this multiplication by a shift.
         * Source: Effective Java, Joshua Bloch, 2008, p.48
         */
        result = 31 * result + Float.floatToIntBits(x);
        result = 31 * result + Float.floatToIntBits(y);
        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "SingleTouch(" + x + "," + y + ")";
    }

}
