//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore.gui;

/**
 * <p>
 * Event type for releasing a mouse button.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public class MouseButtonUp extends MouseButtonInteraction {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Constructor. Creates a new {@link MouseButtonUp} event type.
     * </p>
     * 
     * @see MouseButtonInteraction#MouseButtonInteraction(Button,int,int)
     */
    public MouseButtonUp(Button button, int x, int y) {
        super(button, x, y);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#getName()
     */
    public String getName() {
        if (super.getButton() == Button.LEFT) {
            return "LeftMouseButtonUp";
        }
        else if (super.getButton() == Button.MIDDLE) {
            return "MiddleMouseButtonUp";
        }
        else if (super.getButton() == Button.RIGHT) {
            return "RightMouseButtonUp";
        }
        else {
            return "UnknownMouseButtonUp";
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        if (super.getButton() == Button.LEFT) {
            return "left mouse btn \u21D1 (" + getX() + "," + getY() + ")";
        }
        else if (super.getButton() == Button.MIDDLE) {
            return "middle mouse btn \u21D1 (" + getX() + "," + getY() + ")";
        }
        else if (super.getButton() == Button.RIGHT) {
            return "right mouse btn \u21D1 (" + getX() + "," + getY() + ")";
        }
        else {
            return "unknown mouse btn \u21D1 (" + getX() + "," + getY() + ")";
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MouseButtonUp) {
            return
                getButton().equals(((MouseButtonUp) obj).getButton()) &&
                (getX() == ((MouseButtonUp) obj).getX()) &&
                (getY() == ((MouseButtonUp) obj).getY());
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return getButton().hashCode() + getX() + getY();
    }
}
