//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore;

/**
 * <p>
 * Exception that is thrown if there is a failure during the creation of an
 * {@link IHierarchicalEventTarget} by the {@link IEventTargetFactory}.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public class EventTargetModelConfigurationException extends EventTargetModelException {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Constructor. Creates a new EventTargetModelConfigurationException.
     * </p>
     */
    public EventTargetModelConfigurationException() {
        super();
    }

    /**
     * <p>
     * Constructor. Creates a new EventTargetModelConfigurationException.
     * </p>
     * 
     * @param message
     *            message of the exception
     */
    public EventTargetModelConfigurationException(String message) {
        super(message);
    }

    /**
     * <p>
     * Constructor. Creates a new EventTargetModelConfigurationException.
     * </p>
     * 
     * @param cause
     *            cause of the exception
     */
    public EventTargetModelConfigurationException(Throwable cause) {
        super(cause);
    }

    /**
     * <p>
     * Constructor. Creates a new EventTargetModelConfigurationException.
     * </p>
     * 
     * @param message
     *            message of the exception
     * @param cause
     *            cause of the exception
     */
    public EventTargetModelConfigurationException(String message, Throwable cause) {
        super(message, cause);
    }

}
