//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.test;

import static org.junit.Assert.fail;

import java.util.ArrayList;
import java.util.List;

import de.ugoe.cs.util.console.Command;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @version $Revision: $ $Date: 29.08.2012$
 * @author 2012, last modified by $Author: pharms$
 */
public class CommandRunner {

    /**
     * <p>
     * prevent instantiation
     * </p>
     */
    private CommandRunner() {
        // just to prevent instantiation
    }

    public static void runCommand(Class<? extends Command> commandType, Object... parameters) {
        Command command;
        try {
            command = commandType.getDeclaredConstructor().newInstance();
        }
        catch (Exception e) {
            fail("could not instantiate command");
            return; // just added to prevent compiler warning. But the fail will already throw an
                    // exception
        }
        
        List<Object> params = new ArrayList<Object>();
        
        for (Object parameter : parameters) {
            params.add(parameter);
        }
        
        command.run(params);
    }
}
