//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.commands.usability;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import de.ugoe.cs.autoquest.CommandHelpers;
import de.ugoe.cs.autoquest.tasktrees.treeifc.DefaultTaskTraversingVisitor;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTaskInstance;
import de.ugoe.cs.autoquest.usability.UsabilityEvaluationResult;
import de.ugoe.cs.autoquest.usability.UsabilitySmell;
import de.ugoe.cs.autoquest.usability.UsabilitySmell.ManualLabel;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 * @version 1.0
 */
public class CMDusabilityAutoTagger implements Command {

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#run(java.util.List)
     */
    @Override
    public void run(List<Object> parameters) {
        List<String> usabilityResultNames = new ArrayList<>(parameters.size());
        try {
            for (Object parameter : parameters) {
                usabilityResultNames.add((String) parameter);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }

        List<UsabilityEvaluationResult> usabilityResults = new ArrayList<>(usabilityResultNames.size());
        
        for (String usabilityResultName : usabilityResultNames) {
            Object dataObject = GlobalDataContainer.getInstance().getData(usabilityResultName);
            if (dataObject == null) {
                CommandHelpers.objectNotFoundMessage(usabilityResultName);
                return;
            }
            if (!(dataObject instanceof UsabilityEvaluationResult)) {
                CommandHelpers.objectNotType(usabilityResultName, "UsabilityEvaluationResult");
                return;
            }
            
            usabilityResults.add((UsabilityEvaluationResult) dataObject);
        }
        
        for (UsabilityEvaluationResult result : usabilityResults) {
            for (UsabilitySmell smell : result.getAllSmells()) {
                if (smell.getSmellingTask() != null) {
                    smell.setManualLabel(ManualLabel.TRUE_POSITIVE);
                    
                    final Set<String> usedObjectNames = new HashSet<>();
                    
                    smell.getSmellingTask().accept(new DefaultTaskTraversingVisitor() {
                       @Override
                        public void visit(IEventTask eventTask) {
                           usedObjectNames.add(((IEventTaskInstance) eventTask.getInstances().iterator().next()).getEvent().getTarget().toString()); 
                        }
                    });
                    
                    for (String tag : new LinkedList<String>(smell.getTags())) {
                        smell.removeTag(tag);
                    }
                    
                    if (usedObjectNames.remove("Cup")) {
                        if (!smell.getTags().contains("Cup")) {
                            smell.addTag("Cup");
                        }
                    }
                    if (usedObjectNames.remove("StrongCoffee")) {
                        if (!smell.getTags().contains("Strong Coffee")) {
                            smell.addTag("Strong Coffee");
                        }
                        if (!smell.getTags().contains("Right Button")) {
                            smell.addTag("Right Button");
                        }
                    }
                    if (usedObjectNames.remove("LightCoffee")) {
                        if (!smell.getTags().contains("Light Coffee")) {
                            smell.addTag("Light Coffee");
                        }
                        if (!smell.getTags().contains("Right Button")) {
                            smell.addTag("Right Button");
                        }
                    }
                    if (usedObjectNames.remove("TwoLightCoffees")) {
                        if (!smell.getTags().contains("Two Light Coffees")) {
                            smell.addTag("Two Light Coffees");
                        }
                        if (!smell.getTags().contains("Right Button")) {
                            smell.addTag("Right Button");
                        }
                    }
                    if (usedObjectNames.remove("ButtonCopy")) {
                        if (!smell.getTags().contains("Copy Button")) {
                            smell.addTag("Copy Button");
                        }
                        if (!smell.getTags().contains("Right Button")) {
                            smell.addTag("Right Button");
                        }
                    }
                    if (usedObjectNames.remove("PrinterTop")) {
                        if (!smell.getTags().contains("Printer Top")) {
                            smell.addTag("Printer Top");
                        }
                    }
                    if (usedObjectNames.remove("Paper")) {
                        if (!smell.getTags().contains("Paper")) {
                            smell.addTag("Paper");
                        }
                    }
                    if (usedObjectNames.remove("Paper(Clone)1")) {
                        if (!smell.getTags().contains("Paper")) {
                            smell.addTag("Paper");
                        }
                    }
                    if (usedObjectNames.remove("Paper(Clone)2")) {
                        if (!smell.getTags().contains("Paper")) {
                            smell.addTag("Paper");
                        }
                    }
                    if (usedObjectNames.remove("Buzzer")) {
                        if (!smell.getTags().contains("Reset")) {
                            smell.addTag("Reset");
                        }
                    }
                    if (usedObjectNames.remove("Camera (eye)")) {
                        // ignore
                    }
                    if (usedObjectNames.remove("CenterEyeAnchor")) {
                        // ignore
                    }
                    
                    if (usedObjectNames.size() > 0) {
                        if (!smell.getTags().contains("Wrong Button")) {
                            smell.addTag("Wrong Button");
                        }
                    }
                }
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#help()
     */
    @Override
    public String help() {
        return "eventStatistics [<sequencesName>]*";
    }

}
