//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usageprofiles;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.usageprofiles.TrieBasedModel;

public class MockTrieBasedModel extends TrieBasedModel {
	private static final long serialVersionUID = 1L;

	public MockTrieBasedModel(int markovOrder, Random r) {
		super(markovOrder, r);
	}

	@Override
	public double getProbability(List<Event> context,
			Event symbol) {
		List<Event> list = new ArrayList<Event>();
		if( context.isEmpty() ) {
			return 2;
		}
		list.add(context.get(context.size()-1));
		if( trie.find(list).getFollowingSymbols().contains(symbol) ) {
			return 1;
		} else {
			return 0;
		}
	}
}