//   Copyright 2015 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.eventcore.gui.Scroll;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
public class ActionClassifier {

    /**
     * convenience method to classify an action as inefficient
     */
    public static boolean isInefficient(Event event) {
        return (event.getType() instanceof Scroll) ||
               ("headMoved".equals(event.getType().toString())) ||
               ("headRotated".equals(event.getType().toString()));
    }

    /**
     * convenience method to classify an event task instance as inefficient
     */
    public static boolean isInefficient(IEventTaskInstance eventTaskInstance) {
        return isInefficient(eventTaskInstance.getEvent());
    }

    /**
     * convenience method to classify an event task as inefficient
     */
    public static boolean isInefficient(IEventTask eventTask) {
        for (ITaskInstance instance : eventTask.getInstances()) {
            if (isInefficient((IEventTaskInstance) instance)) {
                return true;
            }
        }
        return false;
    }

}
