//   Copyright 2015 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.genericevents.eventCore;

import de.ugoe.cs.autoquest.eventcore.AbstractDefaultHierarchicalEventTarget;
import de.ugoe.cs.autoquest.eventcore.IEventTargetSpec;
import de.ugoe.cs.autoquest.eventcore.IHierarchicalEventTarget;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
public class GenericEventTarget extends AbstractDefaultHierarchicalEventTarget
    implements IHierarchicalEventTarget
{

    /**  */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param specification
     * @param parent
     */
    public GenericEventTarget(GenericEventTargetSpec specification, GenericEventTarget parent) {
        super(specification, parent);
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.eventcore.IEventTarget#getPlatform()
     */
    @Override
    public String getPlatform() {
        return "Generic Event";
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.eventcore.IEventTarget#getStringIdentifier()
     */
    @Override
    public String getStringIdentifier() {
        return ((GenericEventTargetSpec) super.getSpecification()).getId();
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return super.getSpecification().toString();
    }

    /* (non-Javadoc)
     * @see IHierarchicalEventTarget#updateSpecification(IEventTargetSpec)
     */
    @Override
    public void updateSpecification(IEventTargetSpec furtherSpec) {
        if (!(furtherSpec instanceof GenericEventTargetSpec)) {
            throw new IllegalArgumentException
                ("can only handle specifications of type GenericEventTargetSpec");
        }
        
        ((GenericEventTargetSpec) super.getSpecification()).mergeWith
            ((GenericEventTargetSpec) furtherSpec);
    }
}
