//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.taskequality;

import static org.junit.Assert.*;

import org.junit.Test;

import de.ugoe.cs.autoquest.tasktrees.taskequality.TaskEquality;

/**
 * @author Patrick Harms
 */
public class TaskEqualityTest {

    /**
     *
     */
    @Test
    public void test() {
        assertTrue(TaskEquality.IDENTICAL.isAtLeast(TaskEquality.IDENTICAL));
        assertTrue(TaskEquality.IDENTICAL.isAtLeast(TaskEquality.LEXICALLY_EQUAL));
        assertTrue(TaskEquality.IDENTICAL.isAtLeast(TaskEquality.SYNTACTICALLY_EQUAL));
        assertTrue(TaskEquality.IDENTICAL.isAtLeast(TaskEquality.SEMANTICALLY_EQUAL));
        assertFalse(TaskEquality.IDENTICAL.isAtLeast(TaskEquality.UNEQUAL));

        assertFalse(TaskEquality.LEXICALLY_EQUAL.isAtLeast(TaskEquality.IDENTICAL));
        assertTrue(TaskEquality.LEXICALLY_EQUAL.isAtLeast(TaskEquality.LEXICALLY_EQUAL));
        assertTrue(TaskEquality.LEXICALLY_EQUAL.isAtLeast(TaskEquality.SYNTACTICALLY_EQUAL));
        assertTrue(TaskEquality.LEXICALLY_EQUAL.isAtLeast(TaskEquality.SEMANTICALLY_EQUAL));
        assertFalse(TaskEquality.LEXICALLY_EQUAL.isAtLeast(TaskEquality.UNEQUAL));

        assertFalse(TaskEquality.SYNTACTICALLY_EQUAL.isAtLeast(TaskEquality.IDENTICAL));
        assertFalse(TaskEquality.SYNTACTICALLY_EQUAL.isAtLeast(TaskEquality.LEXICALLY_EQUAL));
        assertTrue(TaskEquality.SYNTACTICALLY_EQUAL.isAtLeast(TaskEquality.SYNTACTICALLY_EQUAL));
        assertTrue(TaskEquality.SYNTACTICALLY_EQUAL.isAtLeast(TaskEquality.SEMANTICALLY_EQUAL));
        assertFalse(TaskEquality.SYNTACTICALLY_EQUAL.isAtLeast(TaskEquality.UNEQUAL));

        assertFalse(TaskEquality.SEMANTICALLY_EQUAL.isAtLeast(TaskEquality.IDENTICAL));
        assertFalse(TaskEquality.SEMANTICALLY_EQUAL.isAtLeast(TaskEquality.LEXICALLY_EQUAL));
        assertFalse(TaskEquality.SEMANTICALLY_EQUAL.isAtLeast(TaskEquality.SYNTACTICALLY_EQUAL));
        assertTrue(TaskEquality.SEMANTICALLY_EQUAL.isAtLeast(TaskEquality.SEMANTICALLY_EQUAL));
        assertFalse(TaskEquality.SEMANTICALLY_EQUAL.isAtLeast(TaskEquality.UNEQUAL));

        assertFalse(TaskEquality.UNEQUAL.isAtLeast(TaskEquality.IDENTICAL));
        assertFalse(TaskEquality.UNEQUAL.isAtLeast(TaskEquality.LEXICALLY_EQUAL));
        assertFalse(TaskEquality.UNEQUAL.isAtLeast(TaskEquality.SYNTACTICALLY_EQUAL));
        assertFalse(TaskEquality.UNEQUAL.isAtLeast(TaskEquality.SEMANTICALLY_EQUAL));
        assertTrue(TaskEquality.UNEQUAL.isAtLeast(TaskEquality.UNEQUAL));
    }

}
