//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.


package de.ugoe.cs.util.console.defaultcommands;

import static org.junit.Assert.*;

import java.util.ArrayList;
import java.util.List;

import org.junit.Before;
import org.junit.Test;

import de.ugoe.cs.util.console.CommandExecuter;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.defaultcommands.CMDlistCommands;
import de.ugoe.cs.util.console.listener.IOutputListener;

public class CMDlistCommandsTest implements IOutputListener {

    private List<String> commands = new ArrayList<String>();

    @Before
    public void setUp() throws Exception {
        Console.getInstance().registerOutputListener(this);
    }

    @Test
    public void test() {
        CommandExecuter.getInstance().addCommandPackage("de.ugoe.cs.util.console.defaultcommands", this.getClass().getClassLoader());
        CMDlistCommands command = new CMDlistCommands();
        command.run(null);

        assertTrue(commands.size() > 0);

        for (String cmd : commands) {
            assertNotNull(cmd);
            assertTrue(cmd.length() > 0);
            System.out.print(cmd);
        }
    }

    @Override
    public void outputMsg(String newMessage) {
        commands.add(newMessage);
    }

}
