package de.ugoe.cs.quest.plugin;

/**
 * <p>
 * Interface for QUEST plug-ins.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public interface QuestPlugin {

	/**
	 * <p>
	 * Title of the plug-in.
	 * </p>
	 * 
	 * @return
	 */
	public String getTitle();

	/**
	 * <p>
	 * Collection of {@link String}s that contain the commands defined by this
	 * plug-in.
	 * </p>
	 * <p>
	 * Consult the de.ugoe.cs.utils.console package of the java-utils project
	 * for more information.
	 * </p>
	 * 
	 * @return
	 */
	public String[] getCommandPackages();
}
