//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.commands.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.List;

import de.ugoe.cs.autoquest.plugin.AutoQUESTPlugin;
import de.ugoe.cs.autoquest.plugin.PluginLoader;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.CommandExecuter;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command that loads a previously serialized {@link GlobalDataContainer}.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDload implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String filename;
		try {
			filename = (String) parameters.get(0);
		} catch (Exception e) {
			throw new IllegalArgumentException();
		}

	        final PluginLoader pluginLoader = new PluginLoader(new File("lib"));
	        pluginLoader.load();

	        FileInputStream fis = null;
		ObjectInputStream in = null;
		try {
			fis = new FileInputStream(filename);
			in = new ObjectInputStream(fis) {
                            @Override
                            protected Class<?> resolveClass(ObjectStreamClass clazz)
                                    throws IOException, ClassNotFoundException
                            {
                                try {
                                    return this.getClass().getClassLoader().loadClass(clazz.getName());
                                }
                                catch (Exception e) {
                                    for (AutoQUESTPlugin plugin : pluginLoader.getPlugins()) {
                                        try {
                                            return plugin.getClass().getClassLoader().loadClass(clazz.getName());
                                        }
                                        catch (Exception e2) {
                                            // ignore and try next
                                        }
                                    }
                                }
                                
                                throw new ClassNotFoundException("could not load class " + clazz.getName() +
                                                                 " neither from normal class loader nor from " +
                                                                 "plug in class loaders");
                            }
			};
			in.readObject();
			in.close();
		} catch (IOException ex) {
			Console.logException(ex);
		} catch (ClassNotFoundException ex) {
			Console.logException(ex);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "load <filename>";
	}

}
