//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeifc;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

// TODO: Auto-generated Javadoc
/**
 * <p>
 * This class represents a complete task model. A task model within AutoQUEST is
 * usually generated based on user sessions. Therefore, the task model consists
 * of the user sessions, the models of the identified tasks, as well as further
 * information about the tasks (e.g. their occurrence count) for statistical
 * processing.
 * </p>
 * 
 * @author 2012, Patrick Harms
 */
public interface ITaskModel extends Cloneable, Serializable {

	/**
	 * <p>
	 * creates a deep clone of the model including all tasks and user sessions.
	 * </p>
	 * 
	 * @return as described
	 */
	public ITaskModel clone();

	/**
	 * <p>
	 * returns a list of all metrics calculated by this model for the tasks and
	 * stored in the respective task infos
	 * </p>.
	 *
	 * @return as described
	 */
	public TaskMetric[] getAllMetrics();

	/**
	 * <p>
	 * returns additional info for the provided task. The method returns null,
	 * if the provided task does not belong to the model.
	 * </p>
	 *
	 * @param task the task
	 * @return as described
	 */
	public ITaskInfo getTaskInfo(ITask task);

	/**
	 * <p>
	 * returns the tasks belonging to the model. The return value must not be
	 * null. However, it may be an empty list, if the model is an empty model.
	 * </p>
	 * 
	 * @return as described
	 */
	public Collection<ITask> getTasks();

	/**
	 * <p>
	 * returns the user sessions belonging to the model. The return value may be
	 * null in the case no user sessions are associated the the tasks in the
	 * model.
	 * </p>
	 * 
	 * @return as described
	 */
	public List<IUserSession> getUserSessions();

}
