//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.temporalrelation.utils;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IIteration;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IOptional;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISelection;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;

/**
 * <p>
 * Utility class to transform a task tree to a plain text representation
 * </p>
 * 
 * @author Patrick Harms
 */
public class DebuggingHelper {

    /**
     *
     */
    public static String toPlainStr(ITask task) {
        StringBuffer result = new StringBuffer();
        toPlainStr(task, result);
        return result.toString();
    }

    /**
     *
     */
    public static void toPlainStr(ITask task, StringBuffer result) {
        if (task instanceof IEventTask) {
            IEventTaskInstance eventTaskInstance =
                (IEventTaskInstance) task.getInstances().iterator().next();
            result.append(eventTaskInstance.getEvent().getType().getName());
            result.append(" on ");
            result.append(eventTaskInstance.getEvent().getTarget());
        }
        else if (task instanceof ISequence) {
            result.append("sequence (");

            for (ITask child : ((ISequence) task).getChildren()) {
                toPlainStr(child, result);
                result.append(", ");
            }

            result.append(")");
        }
        else if (task instanceof ISelection) {
            result.append("selection (");

            for (ITask child : ((ISelection) task).getChildren()) {
                toPlainStr(child, result);
                result.append(", ");
            }

            result.append(")");
        }
        else if (task instanceof IIteration) {
            result.append("iteration (");
            toPlainStr(((IIteration) task).getMarkedTask(), result);
            result.append(")");
        }
        else if (task instanceof IOptional) {
            result.append("optional (");
            toPlainStr(((IOptional) task).getMarkedTask(), result);
            result.append(")");
        }
    }
}
