//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.genericevents.commands;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

import de.ugoe.cs.autoquest.plugin.genericevents.GenericEventLogSplitter;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 * @version 1.0
 */
public class CMDsplitDirGenericEvents implements Command {

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#run(java.util.List)
     */
    @Override
    public void run(List<Object> parameters) {
        String source = null;
        String dest = null;
        long timediff = 0;
        
        try {
            for (int i = 0; i < parameters.size(); i++) {
                String param = (String) parameters.get(i);
                if (source == null) {
                    source = param;
                }
                else if (dest == null) {
                    dest = param;
                }
                else {
                    timediff = Long.parseLong(param);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("illegal parameters provided: " + e);
        }

        File sourceFolder = new File(source);
        if (!sourceFolder.isDirectory()) {
            Console.printerrln(sourceFolder + " is not a directory");
            return;
        }

        File destFolder = new File(dest);
        if (destFolder.exists() && !destFolder.isDirectory()) {
            Console.printerrln(destFolder + " is not a directory");
            return;
        }
        
        if (sourceFolder.equals(destFolder)) {
            Console.printerrln("source and destination must not be the same");
            return;
        }

        splitFile(sourceFolder, destFolder, timediff);
    }

    /**
     * <p>
     * recursive method for parsing a directory structures
     * </p>
     *
     * @param file   the file object to be parsed. If the file is a folder, the method calls itself
     *               for all children
     * @param parser the parser to use for parsing the files.
     */
    private void splitFile(File source, File dest, long timediff) {
        if (source.isDirectory()) {
            String[] children = source.list();
            
            if (children != null) {
            	Arrays.sort(children);

            	for (String child : children) {
            		File childFile = new File(source, child);
            		File childDestination = new File(dest, child);
            		splitFile(childFile, childDestination, timediff);
            	}
            }
        }
        else if (source.isFile()) {
            Console.traceln(Level.INFO, "Processing file: " + source.getAbsolutePath());

            try {
                new GenericEventLogSplitter().splitLogFile(source, dest.getParentFile(), timediff);
            }
            catch (Exception e) {
                Console.printerrln("Could not split " + source.getAbsolutePath() + ": " + e.getMessage());
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#help()
     */
    @Override
    public String help() {
        return "splitDirGenericEvents <directory>";
    }

}
