package de.ugoe.cs.eventbench.swing;

import java.awt.EventQueue;
import javax.swing.JFrame;
import javax.swing.JList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;
import de.ugoe.cs.eventbench.data.Event;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.util.console.Console;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.JScrollPane;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * <p>
 * This class provides the dialog to choose one of the available sequences after
 * parsing a log
 * </p>
 * 
 * @author Jeffrey Hall
 * @version 1.0
 * @deprecated Use SWT-GUI for modifying sequences.
 */
public class DlgSequences {

	/**
	 * <p>
	 * All the sequences that are found in the parsed log
	 * </p>
	 */
	private List<List<Event<?>>> containedSequences;

	private JFrame frmSequences;

	/**
	 * <p>
	 * Launch the dialog
	 * </p>
	 */
	public static void showDialog() {

		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					DlgSequences window = new DlgSequences();
					window.frmSequences.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * <p>
	 * Create the dialog
	 * </p>
	 */
	public DlgSequences() {
		initialize();
	}

	/**
	 * <p>
	 * Initialize the contents of the frame.
	 * </p>
	 */
	@SuppressWarnings("unchecked")
	private void initialize() {
		frmSequences = new JFrame();
		frmSequences.addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosed(WindowEvent arg0) {

				synchronized (Console.getInstance()) {
					Console.getInstance().notify();
				}
			}
		});

		frmSequences.setTitle("Sequences");
		frmSequences.setResizable(false);
		frmSequences.setBounds(100, 100, 270, 332);
		frmSequences.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		frmSequences.getContentPane().setLayout(null);

		final javax.swing.DefaultListModel modelListSequences = new javax.swing.DefaultListModel();
		final JButton btnSequence = new JButton("Show details");
		final JButton btnClose = new JButton("Close");

		JPanel panel = new JPanel();
		panel.setBorder(new EtchedBorder(EtchedBorder.LOWERED, null, null));
		panel.setBounds(10, 11, 244, 218);
		frmSequences.getContentPane().add(panel);
		panel.setLayout(null);

		JScrollPane scrollPane = new JScrollPane();
		scrollPane.setBounds(10, 11, 224, 196);
		panel.add(scrollPane);
		final JList listSequences = new JList(modelListSequences);
		scrollPane.setViewportView(listSequences);

		JPanel panel_1 = new JPanel();
		panel_1.setBorder(new EtchedBorder(EtchedBorder.LOWERED, null, null));
		panel_1.setBounds(10, 240, 244, 53);
		frmSequences.getContentPane().add(panel_1);
		panel_1.setLayout(null);

		// get the available sequences out of globalDataContainer
		try {
			containedSequences = (List<List<Event<?>>>) GlobalDataContainer
					.getInstance().getData("sequences");
		} catch (ClassCastException e) {
			Console.println("Not able to cast data in globalDataContainer to list of sequences");
		}

		// display sequences in the dialog
		try {
			for (int i = 0; i < containedSequences.size(); i++) {
				modelListSequences.addElement("Sequence " + (i + 1) + ": "
						+ containedSequences.get(i).size() + " Events");
			}
		} catch (NullPointerException e) {
			Console.println("No sequences found.");
		}

		// enable/disable the "Show details" button by selecting/deselecting a
		// sequence
		listSequences.addListSelectionListener(new ListSelectionListener() {
			public void valueChanged(ListSelectionEvent arg0) {
				if (listSequences.getSelectedIndex() >= 0)
					btnSequence.setEnabled(true);
				else
					btnSequence.setEnabled(false);
			}
		});

		// listener for clicking the "Show details" button
		btnSequence.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent arg0) {
				if (btnSequence.isEnabled()) {
					DlgSequenceDetails dlgSequences = new DlgSequenceDetails(
							frmSequences, containedSequences.get(listSequences
									.getSelectedIndex()));
					dlgSequences.showDialog(frmSequences, containedSequences
							.get(listSequences.getSelectedIndex()));
					frmSequences.setVisible(false);
				}
			}
		});
		btnSequence.setBounds(124, 11, 110, 32);
		panel_1.add(btnSequence);
		btnSequence.setEnabled(false);

		// listener for clicking the "Close" button
		btnClose.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent arg0) {
				frmSequences.dispose();
			}
		});
		btnClose.setBounds(10, 11, 110, 32);
		panel_1.add(btnClose);
	}
}
