package de.ugoe.cs.eventbench;

import de.ugoe.cs.eventbench.log4j.Log4JLogger;
import de.ugoe.cs.eventbench.swt.MainWindow;
import de.ugoe.cs.util.console.CommandExecuter;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.TextConsole;

/**
 * <p>
 * Start-up class of the application.
 * </p>
 * <p>
 * It sets up and starts the {@link Console}.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class Runner {

	/**
	 * <p>
	 * Main method of the application.
	 * </p>
	 * 
	 * @param args
	 *            if parameters are defined, they are interpreted as commands
	 *            for the {@link Console} and executed before the user can use
	 *            the console; can be used to perform batch operations
	 */
	public static void main(String[] args) {
		CommandExecuter.getInstance().addCommandPackage(
				"de.ugoe.cs.eventbench.commands");
		CommandExecuter.getInstance().addCommandPackage(
				"de.ugoe.cs.eventbench.windows.commands");
		CommandExecuter.getInstance().addCommandPackage(
				"de.ugoe.cs.eventbench.web.commands");
		CommandExecuter.getInstance().addCommandPackage(
				"de.ugoe.cs.eventbench.efg.commands");
		TextConsole textConsole = new TextConsole();
		new Log4JLogger();
		boolean swtGuiRunning = false;
		if (args.length >= 1) {
			if( args[0].equals("-swt") ) {
				MainWindow mainWindow = new MainWindow();
				mainWindow.open();
				swtGuiRunning = true;
			} else {
				for (String command : args) {
					CommandExecuter.getInstance().exec(command);
				}
			}
		}
		if( !swtGuiRunning ) {
			textConsole.run(true);
		}
	}

}
