package de.ugoe.cs.eventbench.commands;

import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.models.FirstOrderMarkovModel;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to calculate the entropy of first-order Markov models.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDcalcEntropy implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: calcEntropy <modelname>");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String modelname = "";
		try {
			modelname = (String) parameters.get(0);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		FirstOrderMarkovModel model = null;
		Object dataObject = GlobalDataContainer.getInstance()
				.getData(modelname);
		if (dataObject == null) {
			Console.println("Model " + modelname + "not found in storage.");
			return;
		}
		if (!(dataObject instanceof FirstOrderMarkovModel)) {
			Console.println("Object " + modelname
					+ " is not a first-order Markov model!");
			return;
		}
		model = (FirstOrderMarkovModel) dataObject;
		double entropy = model.calcEntropy();
		if (!Double.isNaN(entropy)) {
			Console.println("entropy: " + entropy);
		}
	}

}
