package de.ugoe.cs.eventbench.windows;

/**
 * <p>
 * Contains definitions of windows message codes, such that they can be used
 * internally by their name and not their integer value, to improve the
 * readability of the source code.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public interface MessageDefs {

	public static final int WM_NULL = 0;
	public static final int WM_CREATE = 1;
	public static final int WM_DESTROY = 2;
	public static final int WM_MOVE = 3;
	public static final int WM_SIZE = 5;
	public static final int WM_ACTIVATE = 6;
	public static final int WM_SETFOCUS = 7;
	public static final int WM_KILLFOCUS = 8;
	public static final int WM_ENABLE = 10;
	public static final int WM_SETREDRAW = 11;
	public static final int WM_SETTEXT = 12;
	public static final int WM_GETTEXT = 13;
	public static final int WM_GETTEXTLENGTH = 14;
	public static final int WM_PAINT = 15;
	public static final int WM_CLOSE = 16;
	public static final int WM_QUERYENDSESSION = 17;
	public static final int WM_QUIT = 18;
	public static final int WM_QUERYOPEN = 19;
	public static final int WM_ERASEBKGND = 20;
	public static final int WM_SYSCOLORCHANGE = 21;
	public static final int WM_ENDSESSION = 22;
	public static final int WM_SHOWWINDOW = 24;
	public static final int WM_CTLCOLOR = 25;
	public static final int WM_WININICHANGE = 26;
	public static final int WM_DEVMODECHANGE = 27;
	public static final int WM_ACTIVATEAPP = 28;
	public static final int WM_FONTCHANGE = 29;
	public static final int WM_TIMECHANGE = 30;
	public static final int WM_CANCELMODE = 31;
	public static final int WM_SETCURSOR = 32;
	public static final int WM_MOUSEACTIVATE = 33;
	public static final int WM_CHILDACTIVATE = 34;
	public static final int WM_QUEUESYNC = 35;
	public static final int WM_GETMINMAXINFO = 36;
	public static final int WM_PAINTICON = 38;
	public static final int WM_ICONERASEBKGND = 39;
	public static final int WM_NEXTDLGCTL = 40;
	public static final int WM_SPOOLERSTATUS = 42;
	public static final int WM_DRAWITEM = 43;
	public static final int WM_MEASUREITEM = 44;
	public static final int WM_DELETEITEM = 45;
	public static final int WM_VKEYTOITEM = 46;
	public static final int WM_CHARTOITEM = 47;
	public static final int WM_SETFONT = 48;
	public static final int WM_GETFONT = 49;
	public static final int WM_SETHOTKEY = 50;
	public static final int WM_GETHOTKEY = 51;
	public static final int WM_QUERYDRAGICON = 55;
	public static final int WM_COMPAREITEM = 57;
	public static final int WM_GETOBJECT = 61;
	public static final int WM_COMPACTING = 65;
	public static final int WM_COMMNOTIFY = 68;
	public static final int WM_WINDOWPOSCHANGING = 70;
	public static final int WM_WINDOWPOSCHANGED = 71;
	public static final int WM_POWER = 72;
	public static final int WM_COPYDATA = 74;
	public static final int WM_CANCELJOURNAL = 75;
	public static final int WM_NOTIFY = 78;
	public static final int WM_INPUTLANGCHANGEREQUEST = 80;
	public static final int WM_INPUTLANGCHANGE = 81;
	public static final int WM_TCARD = 82;
	public static final int WM_HELP = 83;
	public static final int WM_USERCHANGED = 84;
	public static final int WM_NOTIFYFORMAT = 85;
	public static final int WM_CONTEXTMENU = 123;
	public static final int WM_STYLECHANGING = 124;
	public static final int WM_STYLECHANGED = 125;
	public static final int WM_DISPLAYCHANGE = 126;
	public static final int WM_GETICON = 127;
	public static final int WM_SETICON = 128;
	public static final int WM_NCCREATE = 129;
	public static final int WM_NCDESTROY = 130;
	public static final int WM_NCCALCSIZE = 131;
	public static final int WM_NCHITTEST = 132;
	public static final int WM_NCPAINT = 133;
	public static final int WM_NCACTIVATE = 134;
	public static final int WM_GETDLGCODE = 135;
	public static final int WM_SYNCPAINT = 136;
	public static final int WM_NCMOUSEMOVE = 160;
	public static final int WM_NCLBUTTONDOWN = 161;
	public static final int WM_NCLBUTTONUP = 162;
	public static final int WM_NCLBUTTONDBLCLK = 163;
	public static final int WM_NCRBUTTONDOWN = 164;
	public static final int WM_NCRBUTTONUP = 165;
	public static final int WM_NCRBUTTONDBLCLK = 166;
	public static final int WM_NCMBUTTONDOWN = 167;
	public static final int WM_NCMBUTTONUP = 168;
	public static final int WM_NCMBUTTONDBLCLK = 169;
	public static final int WM_NCXBUTTONDOWN = 171;
	public static final int WM_NCXBUTTONUP = 172;
	public static final int WM_NCXBUTTONDBLCLK = 173;
	public static final int WM_INPUT = 255;
	public static final int WM_KEYDOWN = 256;
	public static final int WM_KEYFIRST = 256;
	public static final int WM_KEYUP = 257;
	public static final int WM_CHAR = 258;
	public static final int WM_DEADCHAR = 259;
	public static final int WM_SYSKEYDOWN = 260;
	public static final int WM_SYSKEYUP = 261;
	public static final int WM_SYSCHAR = 262;
	public static final int WM_SYSDEADCHAR = 263;
	public static final int WM_KEYLAST = 264;
	public static final int WM_WNT_CONVERTREQUESTEX = 265;
	public static final int WM_CONVERTREQUEST = 266;
	public static final int WM_CONVERTRESULT = 267;
	public static final int WM_INTERIM = 268;
	public static final int WM_IME_STARTCOMPOSITION = 269;
	public static final int WM_IME_ENDCOMPOSITION = 270;
	public static final int WM_IME_COMPOSITION = 271;
	public static final int WM_IME_KEYLAST = 271;
	public static final int WM_INITDIALOG = 272;
	public static final int WM_COMMAND = 273;
	public static final int WM_SYSCOMMAND = 274;
	public static final int WM_TIMER = 275;
	public static final int WM_HSCROLL = 276;
	public static final int WM_VSCROLL = 277;
	public static final int WM_INITMENU = 278;
	public static final int WM_INITMENUPOPUP = 279;
	public static final int WM_MENUSELECT = 287;
	public static final int WM_MENUCHAR = 288;
	public static final int WM_ENTERIDLE = 289;
	public static final int WM_MENURBUTTONUP = 290;
	public static final int WM_MENUDRAG = 291;
	public static final int WM_MENUGETOBJECT = 292;
	public static final int WM_UNINTMENUPOPUP = 293;
	public static final int WM_MENUCOMMAND = 294;
	public static final int WM_CHANGEUISTATE = 295;
	public static final int WM_UPDATEUISTATE = 296;
	public static final int WM_QUERYUISTATE = 297;
	public static final int WM_CTLCOLORMSGBOX = 306;
	public static final int WM_CTLCOLOREDIT = 307;
	public static final int WM_CTLCOLORLISTBOX = 308;
	public static final int WM_CTLCOLORBTN = 309;
	public static final int WM_CTLCLOLORDLG = 310;
	public static final int WM_CTLCOLORSCROLLBAR = 311;
	public static final int WM_CTLCOLORSTATIC = 312;
	public static final int WM_MOUSEFIRST = 512;
	public static final int WM_MOUSEMOVE = 512;
	public static final int WM_LBUTTONDOWN = 513;
	public static final int WM_LBUTTONUP = 514;
	public static final int WM_LBUTTONDBLCLK = 515;
	public static final int WM_RBUTTONDOWN = 516;
	public static final int WM_RBUTTONUP = 517;
	public static final int WM_RBUTTONDBLCLK = 518;
	public static final int WM_MBUTTONDOWN = 519;
	public static final int WM_MBUTTONUP = 520;
	public static final int WM_MBUTTONDBLCLK = 521;
	public static final int WM_MOUSELAST = 521;
	public static final int WM_MOUSEWHEEL = 522;
	public static final int WM_XBUTTONDOWN = 523;
	public static final int WM_XBUTTONUP = 524;
	public static final int WM_XBUTTONDBLCLK = 525;
}
