package de.ugoe.cs.eventbench.windows.commands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.eventbench.windows.LogPreprocessor;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to pre-process all files in a folder.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDconvertDirToXml implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: convertToXml <sourceFolder> <targetFile> {<base64>}");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		if (parameters.size() < 2) {
			throw new InvalidParameterException();
		}
		String path = (String) parameters.get(0);
		String target = (String) parameters.get(1);
		boolean base64 = false;
		if (parameters.size() == 3) {
			base64 = Boolean.parseBoolean((String) parameters.get(2));
		}

		try {
			new LogPreprocessor(base64).convertDirToXml(path, target);
		} catch (FileNotFoundException e) {
			Console.println(e.getMessage());
		} catch (IOException e) {
			Console.println(e.getMessage());
		}

	}

}
