package de.ugoe.cs.eventbench.swt;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;

import de.ugoe.cs.util.StringTools;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.listener.ICommandListener;
import de.ugoe.cs.util.console.listener.IErrorListener;
import de.ugoe.cs.util.console.listener.IOutputListener;
import de.ugoe.cs.util.console.listener.ITraceListener;

public class SWTConsole implements IOutputListener, IErrorListener, ITraceListener, ICommandListener {

	StyledText output;
	
	public SWTConsole(StyledText styledText) {
		Console.getInstance().registerOutputListener(this);
		Console.getInstance().registerErrorListener(this);
		Console.getInstance().registerTraceListener(this);
		Console.getInstance().registerCommandListener(this);
		this.output = styledText;
	}
	
	@Override
	public void outputMsg(String newMessage) {
		output.append(newMessage);
	}

	@Override
	public void errorMsg(String errMessage) {
		appendColored(errMessage, SWT.COLOR_RED);
	}

	@Override
	public void traceMsg(String traceMessage) {
		appendColored(traceMessage, SWT.COLOR_BLUE);
	}
	
	@Override
	public void commandNotification(String command) {
		output.append("> " + command + StringTools.ENDLINE);	
	}
	
	private void appendColored(String str, int id) {
		StyleRange styleRange = new StyleRange();
		styleRange.start = output.getText().length();
		styleRange.length = str.length();
		styleRange.foreground = output.getDisplay().getSystemColor(id);
		output.append(str);
		output.setStyleRange(styleRange);
	}
}
