package de.ugoe.cs.eventbench.commands;

import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.eventbench.CommandHelpers;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to show the time elapsed since a timer has been started.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDshowTimer implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String timerName;
		try {
			timerName = (String) parameters.get(0);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		Object dataObject = (Long) GlobalDataContainer.getInstance().getData(
				timerName);
		if (dataObject == null) {
			CommandHelpers.objectNotFoundMessage(timerName);
			return;
		}
		if (!(dataObject instanceof Long)) {
			CommandHelpers.objectNotType(timerName, "Long");
			return;
		}

		long startTime = (Long) dataObject;
		long currentTime = System.currentTimeMillis();
		Console.traceln("" + (currentTime - startTime) + " milliseconds");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: showTimer <timerName>");
	}

}
