package de.ugoe.cs.eventbench.swt;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

import de.ugoe.cs.util.console.CommandExecuter;

public class SWTHelpers {
	
	public static boolean deleteSelectedFromStorage(final List list) {
		String[] selectedStrings = list.getSelection();
		if( selectedStrings.length==0 ) {
			return false;
		} else {
			for( String selected : selectedStrings) {
				String command = "deleteObject " + selected;
				CommandExecuter.getInstance().exec(command);
			}
			return true;
		}
	}
	
	public static void noSelectionError(final Shell shell) {
		MessageBox messageBox = new MessageBox(shell, SWT.ERROR);
		messageBox.setMessage("No objects selected!");
		messageBox.setText("Error");
		messageBox.open();
	}

}
