package de.ugoe.cs.eventbench.log4j;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.listener.ICommandListener;
import de.ugoe.cs.util.console.listener.IErrorListener;
import de.ugoe.cs.util.console.listener.IExceptionListener;
import de.ugoe.cs.util.console.listener.ITraceListener;

/**
 * <p>
 * Implements logging based on the log4j API.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class Log4JLogger implements IErrorListener, ITraceListener,
		IExceptionListener, ICommandListener {

	/**
	 * <p>
	 * Reference to the logger.
	 * </p>
	 */
	Logger logger;

	/**
	 * <p>
	 * Constructor. Creates a new Log4JLogger and registers the implemented
	 * listener with the {@link Console}.
	 * </p>
	 */
	public Log4JLogger() {
		PropertyConfigurator.configure("misc/log4j.properties");
		logger = Logger.getLogger("de.ugoe.cs.eventbench");
		Console.getInstance().registerErrorListener(this);
		Console.getInstance().registerTraceListener(this);
		Console.getInstance().registerExceptionListener(this);
		Console.getInstance().registerCommandListener(this);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * de.ugoe.cs.util.console.listener.ICommandListener#commandNotification
	 * (java.lang.String)
	 */
	@Override
	public void commandNotification(String command) {
		logger.info("Command executed: " + command);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * de.ugoe.cs.util.console.listener.IExceptionListener#printStacktrace(java
	 * .lang.Exception)
	 */
	@Override
	public void logException(Exception e) {
		logger.error("", e);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * de.ugoe.cs.util.console.listener.ITraceListener#traceMsg(java.lang.String
	 * )
	 */
	@Override
	public void traceMsg(String traceMessage) {
		logger.trace(traceMessage);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * de.ugoe.cs.util.console.listener.IErrorListener#errorMsg(java.lang.String
	 * )
	 */
	@Override
	public void errorMsg(String errMessage) {
		logger.error(errMessage);
	}
}
