package de.ugoe.cs.eventbench.windows.commands;

import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;

import de.ugoe.cs.eventbench.CommandHelpers;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.windows.LogParser;
import de.ugoe.cs.eventbench.windows.data.WindowTree;
import de.ugoe.cs.eventbench.windows.data.WindowsEvent;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to parse an XML file with sessions monitored by EventBench's
 * MFCUsageMonitor.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDparseXML implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: parseXML <filename> {<sequencesName>} {<countMessageOccurences>}");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String filename;
		String sequencesName = "sequences";
		boolean countMessageOccurences = false;

		try {
			filename = (String) parameters.get(0);
			if (parameters.size() >= 2) {
				sequencesName = (String) parameters.get(1);
			}
			if (parameters.size() >= 3) {
				countMessageOccurences = Boolean
						.parseBoolean((String) parameters.get(2));
			}
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		LogParser parser = new LogParser(countMessageOccurences);
		parser.parseFile(filename);

		Collection<List<WindowsEvent>> sequences = parser.getSequences();
		SortedSet<String> targets = WindowTree.getInstance().getTargets();

		if (GlobalDataContainer.getInstance().addData(sequencesName, sequences)) {
			CommandHelpers.dataOverwritten(sequencesName);
		}
		if (GlobalDataContainer.getInstance().addData(
				sequencesName + "_targets", targets)) {
			CommandHelpers.dataOverwritten(sequencesName + "_targets");
		}
	}

}
