package de.ugoe.cs.eventbench.jfcmonitor;

import java.awt.AWTEvent;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class JFCListener implements AWTEventListener {

	@Override
	public void eventDispatched(AWTEvent event) {
		// TODO implement event handler in a way that monitors the click instead of just writing strings to the console
		if( event instanceof MouseEvent ) {
			MouseEvent mouseEvent = (MouseEvent) event;
			if( mouseEvent.getID()==MouseEvent.MOUSE_CLICKED ) {
				System.out.println(event.toString());
			}
		}
		if( event instanceof KeyEvent ) {
			KeyEvent keyEvent = (KeyEvent) event;
			if( keyEvent.getID()==KeyEvent.KEY_TYPED ) {
				System.out.println(event.toString());
			}
		}
	}

}
