package de.ugoe.cs.eventbench.messagehandler;

import de.ugoe.cs.eventbench.data.WindowTree;

public class HandlerCreate extends MessageHandler {

	public HandlerCreate() {
		super();
	}

	private String windowName;
	private int hwnd;
	private int parentHwnd;
	private int resourceId;
	private String className;
	private boolean isModal;
	
	@Override
	public void onEndElement() {
		if( hwnd!=0 ) {
			WindowTree.getInstance().add(parentHwnd, hwnd, windowName, resourceId, className, isModal);
		}
	}

	@Override
	public void onParameter(String name, String value) {
		if( name.equals("window.hwnd") ) {
			hwnd = Integer.parseInt(value);
		}
		else if( name.equals("window.name") ) {
			windowName = value;
		}
		else if( name.equals("window.parent.hwnd") ) {
			parentHwnd = Integer.parseInt(value);
		}
		else if( name.equals("window.resourceId") ) {
			resourceId = Integer.parseInt(value);
		}
		else if( name.equals("window.class") ) {
			if( value.startsWith("Afx:") ) {
				className = "Afx:";
			} else {
				className = value;
			}
		}
		else if( name.equals("window.ismodal") ) {
			if( value.equals("true") || value.equals("1") ) {
				isModal = true;
			}
		}
	}

	@Override
	public void onStartElement() {
		windowName = "";
		hwnd = 0;
		parentHwnd = 0;
		resourceId = 0;
		className = "";
		isModal = false;
	}

}
