package de.ugoe.cs.eventbench.assertions;

import de.ugoe.cs.eventbench.data.IReplayable;
import de.ugoe.cs.util.StringTools;

/**
 * <p>
 * This class defines the replay for a textEquals assertion.
 * </p>
 * 
 * @author Jeffrey Hall, Steffen Herbold
 * @version 2.0
 */
public class TextEqualsReplay implements IReplayable {

	/**
	 * <p>
	 * Reference value which is compared to the targets text.
	 * </p>
	 */
	private String expectedValue;

	/**
	 * <p>
	 * Target to which the text is compared.
	 * </p>
	 */
	private String target;

	/**
	 * <p>
	 * Id for object serialization.
	 * </p>
	 */
	private static final long serialVersionUID = 1L;

	public TextEqualsReplay(String expectedValue, String target) {
		this.expectedValue = expectedValue;
		this.target = target;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.eventbench.data.IReplayable#getReplay()
	 */
	@Override
	public String getReplay() {

		expectedValue = StringTools.xmlEntityReplacement(expectedValue);

		StringBuilder currentMsgStr = new StringBuilder(400);
		currentMsgStr.append(" <textEquals expectedValue=\"" + expectedValue
				+ "\">");
		currentMsgStr.append(StringTools.ENDLINE);
		currentMsgStr.append("<target>");
		currentMsgStr.append(StringTools.ENDLINE);
		currentMsgStr.append(target);
		currentMsgStr.append(StringTools.ENDLINE);
		currentMsgStr.append("</target>");
		currentMsgStr.append(StringTools.ENDLINE);
		currentMsgStr.append("</textEquals>");
		currentMsgStr.append(StringTools.ENDLINE);
		return currentMsgStr.toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.eventbench.data.IReplayable#getTarget()
	 */
	@Override
	public String getTarget() {
		return target;
	}

}
