/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.type;

import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AbstractFrameModelingVisitor;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Debug;
import edu.umd.cs.findbugs.ba.FieldSummary;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Hierarchy2;
import edu.umd.cs.findbugs.ba.InvalidBytecodeException;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.ba.generic.GenericObjectType;
import edu.umd.cs.findbugs.ba.generic.GenericSignatureParser;
import edu.umd.cs.findbugs.ba.generic.GenericUtilities;
import edu.umd.cs.findbugs.ba.type.FieldStoreType;
import edu.umd.cs.findbugs.ba.type.FieldStoreTypeDatabase;
import edu.umd.cs.findbugs.ba.type.NullType;
import edu.umd.cs.findbugs.ba.type.TopType;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.type.TypeMerger;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.util.Util;
import java.util.BitSet;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTypeTable;
import org.apache.bcel.generic.AALOAD;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ARRAYLENGTH;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BALOAD;
import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.CALOAD;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.D2F;
import org.apache.bcel.generic.D2I;
import org.apache.bcel.generic.D2L;
import org.apache.bcel.generic.DADD;
import org.apache.bcel.generic.DALOAD;
import org.apache.bcel.generic.DCMPG;
import org.apache.bcel.generic.DCMPL;
import org.apache.bcel.generic.DCONST;
import org.apache.bcel.generic.DDIV;
import org.apache.bcel.generic.DMUL;
import org.apache.bcel.generic.DNEG;
import org.apache.bcel.generic.DREM;
import org.apache.bcel.generic.DSUB;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.F2D;
import org.apache.bcel.generic.F2I;
import org.apache.bcel.generic.F2L;
import org.apache.bcel.generic.FADD;
import org.apache.bcel.generic.FALOAD;
import org.apache.bcel.generic.FCMPG;
import org.apache.bcel.generic.FCMPL;
import org.apache.bcel.generic.FCONST;
import org.apache.bcel.generic.FDIV;
import org.apache.bcel.generic.FMUL;
import org.apache.bcel.generic.FNEG;
import org.apache.bcel.generic.FREM;
import org.apache.bcel.generic.FSUB;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.I2B;
import org.apache.bcel.generic.I2C;
import org.apache.bcel.generic.I2D;
import org.apache.bcel.generic.I2F;
import org.apache.bcel.generic.I2L;
import org.apache.bcel.generic.I2S;
import org.apache.bcel.generic.IADD;
import org.apache.bcel.generic.IALOAD;
import org.apache.bcel.generic.IAND;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.IDIV;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFGT;
import org.apache.bcel.generic.IFLE;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.IMUL;
import org.apache.bcel.generic.INEG;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.IOR;
import org.apache.bcel.generic.IREM;
import org.apache.bcel.generic.ISHL;
import org.apache.bcel.generic.ISHR;
import org.apache.bcel.generic.ISUB;
import org.apache.bcel.generic.IUSHR;
import org.apache.bcel.generic.IXOR;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.JSR;
import org.apache.bcel.generic.JSR_W;
import org.apache.bcel.generic.L2D;
import org.apache.bcel.generic.L2F;
import org.apache.bcel.generic.L2I;
import org.apache.bcel.generic.LADD;
import org.apache.bcel.generic.LALOAD;
import org.apache.bcel.generic.LAND;
import org.apache.bcel.generic.LCMP;
import org.apache.bcel.generic.LCONST;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.LDIV;
import org.apache.bcel.generic.LMUL;
import org.apache.bcel.generic.LNEG;
import org.apache.bcel.generic.LOR;
import org.apache.bcel.generic.LREM;
import org.apache.bcel.generic.LSHL;
import org.apache.bcel.generic.LSHR;
import org.apache.bcel.generic.LSUB;
import org.apache.bcel.generic.LUSHR;
import org.apache.bcel.generic.LXOR;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.ReturnaddressType;
import org.apache.bcel.generic.SALOAD;
import org.apache.bcel.generic.SIPUSH;
import org.apache.bcel.generic.StoreInstruction;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeFrameModelingVisitor
extends AbstractFrameModelingVisitor<Type, TypeFrame>
implements Constants,
Debug {
    private ValueNumberDataflow valueNumberDataflow;
    private boolean instanceOfFollowedByBranch;
    private ReferenceType instanceOfType;
    private ValueNumber instanceOfValueNumber;
    private FieldSummary fieldSummary;
    private FieldStoreTypeDatabase database;
    private Set<ReferenceType> typesComputedFromGenerics = Util.newSetFromMap(new IdentityHashMap());
    protected final TypeMerger typeMerger;
    protected LocalVariableTypeTable localTypeTable;
    protected BitSet genericLocalVariables;
    boolean sawEffectiveInstanceOf;
    boolean previousWasEffectiveInstanceOf;
    public static final boolean DEBUG = SystemProperties.getBoolean("tfmv.debug");

    public TypeFrameModelingVisitor(ConstantPoolGen cpg, TypeMerger typeMerger) {
        super(cpg);
        this.fieldSummary = AnalysisContext.currentAnalysisContext().getFieldSummary();
        this.typeMerger = typeMerger;
    }

    public void setValueNumberDataflow(ValueNumberDataflow valueNumberDataflow) {
        this.valueNumberDataflow = valueNumberDataflow;
    }

    public void setLocalTypeTable(LocalVariableTypeTable localTypeTable) {
        this.localTypeTable = localTypeTable;
        if (localTypeTable == null) {
            this.genericLocalVariables = null;
        } else {
            this.genericLocalVariables = new BitSet();
            for (LocalVariable lv : localTypeTable.getLocalVariableTypeTable()) {
                if (lv.getSignature().indexOf(60) <= 0) continue;
                this.genericLocalVariables.set(lv.getIndex());
            }
        }
    }

    public boolean isInstanceOfFollowedByBranch() {
        return this.instanceOfFollowedByBranch;
    }

    public Type getInstanceOfType() {
        return this.instanceOfType;
    }

    public ValueNumber getInstanceOfValueNumber() {
        return this.instanceOfValueNumber;
    }

    public void setFieldStoreTypeDatabase(FieldStoreTypeDatabase database) {
        this.database = database;
    }

    @Override
    public Type getDefaultValue() {
        return TypeFrame.getBottomType();
    }

    @Override
    public void analyzeInstruction(Instruction ins) throws DataflowAnalysisException {
        this.instanceOfFollowedByBranch = false;
        this.sawEffectiveInstanceOf = false;
        super.analyzeInstruction(ins);
        this.previousWasEffectiveInstanceOf = this.sawEffectiveInstanceOf;
    }

    public void startBasicBlock() {
        this.instanceOfType = null;
        this.instanceOfValueNumber = null;
    }

    protected void consumeStack(Instruction ins) {
        ConstantPoolGen cpg = this.getCPG();
        TypeFrame frame = (TypeFrame)this.getFrame();
        int numWordsConsumed = ins.consumeStack(cpg);
        if (numWordsConsumed == -2) {
            throw new InvalidBytecodeException("Unpredictable stack consumption for " + ins);
        }
        try {
            while (numWordsConsumed-- > 0) {
                frame.popValue();
            }
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException("Stack underflow for " + ins + ": " + e.getMessage());
        }
    }

    protected void pushValue(Type type) {
        if (type.getType() == 12) {
            throw new IllegalArgumentException("Can't push void");
        }
        TypeFrame frame = (TypeFrame)this.getFrame();
        if (type.getType() == 11) {
            frame.pushValue(Type.LONG);
            frame.pushValue(TypeFrame.getLongExtraType());
        } else if (type.getType() == 7) {
            frame.pushValue(Type.DOUBLE);
            frame.pushValue(TypeFrame.getDoubleExtraType());
        } else {
            frame.pushValue(type);
        }
    }

    protected void pushReturnType(InvokeInstruction ins) {
        ConstantPoolGen cpg = this.getCPG();
        Type type = ins.getType(cpg);
        if (type.getType() != 12) {
            this.pushValue(type);
        }
    }

    @Override
    public void modelNormalInstruction(Instruction ins, int numWordsConsumed, int numWordsProduced) {
        if (VERIFY_INTEGRITY && numWordsProduced > 0) {
            throw new InvalidBytecodeException("missing visitor method for " + ins);
        }
        super.modelNormalInstruction(ins, numWordsConsumed, numWordsProduced);
    }

    @Override
    public void visitATHROW(ATHROW obj) {
    }

    @Override
    public void visitACONST_NULL(ACONST_NULL obj) {
        this.pushValue(TypeFrame.getNullType());
    }

    @Override
    public void visitDCONST(DCONST obj) {
        this.pushValue(Type.DOUBLE);
    }

    @Override
    public void visitFCONST(FCONST obj) {
        this.pushValue(Type.FLOAT);
    }

    @Override
    public void visitICONST(ICONST obj) {
        this.pushValue(Type.INT);
    }

    @Override
    public void visitLCONST(LCONST obj) {
        this.pushValue(Type.LONG);
    }

    @Override
    public void visitLDC(LDC obj) {
        this.pushValue(obj.getType(this.getCPG()));
    }

    @Override
    public void visitLDC2_W(LDC2_W obj) {
        this.pushValue(obj.getType(this.getCPG()));
    }

    @Override
    public void visitBIPUSH(BIPUSH obj) {
        this.pushValue(Type.INT);
    }

    @Override
    public void visitSIPUSH(SIPUSH obj) {
        this.pushValue(Type.INT);
    }

    @Override
    public void visitGETSTATIC(GETSTATIC obj) {
        this.modelFieldLoad(obj);
    }

    @Override
    public void visitGETFIELD(GETFIELD obj) {
        this.modelFieldLoad(obj);
    }

    public void modelFieldLoad(FieldInstruction obj) {
        this.consumeStack(obj);
        Type loadType = obj.getFieldType(this.cpg);
        XField xfield = Hierarchy.findXField(obj, this.getCPG());
        if (xfield != null) {
            loadType = TypeFrameModelingVisitor.getType(xfield);
        }
        this.pushValue(loadType);
    }

    public static Type getType(XField xfield) {
        FieldStoreType property;
        Type t = Type.getType(xfield.getSignature());
        if (!(t instanceof ReferenceType)) {
            return t;
        }
        ReferenceType loadType = (ReferenceType)t;
        FieldStoreTypeDatabase database = AnalysisContext.currentAnalysisContext().getFieldStoreTypeDatabase();
        if (database != null && (property = (FieldStoreType)database.getProperty(xfield.getFieldDescriptor())) != null) {
            loadType = property.getLoadType(loadType);
        } else {
            OpcodeStack.Item summary;
            FieldSummary fieldSummary = AnalysisContext.currentAnalysisContext().getFieldSummary();
            if (fieldSummary != null && (summary = fieldSummary.getSummary(xfield)) != null) {
                if (xfield.isFinal() && summary.isNull()) {
                    return TypeFrame.getNullType();
                }
                if (!summary.getSignature().equals("Ljava/lang/Object;")) {
                    loadType = (ReferenceType)Type.getType(summary.getSignature());
                }
            }
        }
        String sourceSignature = xfield.getSourceSignature();
        if (sourceSignature != null && loadType instanceof ObjectType) {
            loadType = GenericUtilities.merge(GenericUtilities.getType(sourceSignature), (ObjectType)loadType);
        }
        return loadType;
    }

    @Override
    public void visitINVOKESTATIC(INVOKESTATIC obj) {
        String methodName = obj.getMethodName(this.cpg);
        String signature = obj.getSignature(this.cpg);
        String className = obj.getClassName(this.cpg);
        if (methodName.equals("asList") && className.equals("java.util.Arrays") && signature.equals("([Ljava/lang/Object;)Ljava/util/List;")) {
            this.consumeStack(obj);
            Type returnType = Type.getType("Ljava/util/Arrays$ArrayList;");
            this.pushValue(returnType);
            return;
        }
        this.visitInvokeInstructionCommon(obj);
    }

    @Override
    public void visitINVOKESPECIAL(INVOKESPECIAL obj) {
        this.visitInvokeInstructionCommon(obj);
    }

    @Override
    public void visitINVOKEINTERFACE(INVOKEINTERFACE obj) {
        this.visitInvokeInstructionCommon(obj);
    }

    @Override
    public void visitINVOKEVIRTUAL(INVOKEVIRTUAL obj) {
        this.visitInvokeInstructionCommon(obj);
    }

    private boolean getResultTypeFromGenericType(TypeFrame frame, int index, int expectedParameters) {
        try {
            GenericObjectType genericMapType;
            List<? extends ReferenceType> parameters;
            Type mapType = (Type)frame.getStackValue(0);
            if (mapType instanceof GenericObjectType && (parameters = (genericMapType = (GenericObjectType)mapType).getParameters()) != null && parameters.size() == expectedParameters) {
                ReferenceType resultType = parameters.get(index);
                if (resultType instanceof GenericObjectType) {
                    resultType = ((GenericObjectType)resultType).produce();
                }
                this.typesComputedFromGenerics.add(resultType);
                frame.popValue();
                frame.pushValue(resultType);
                return true;
            }
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.logError("oops", e);
        }
        return false;
    }

    private boolean handleGetMapView(TypeFrame frame, String typeName, int index, int expectedNumberOfTypeParameters) {
        try {
            Type mapType = (Type)frame.getStackValue(0);
            if (mapType instanceof GenericObjectType) {
                GenericObjectType genericMapType = (GenericObjectType)mapType;
                List<? extends ReferenceType> parameters = genericMapType.getParameters();
                if (parameters == null) {
                    return false;
                }
                if (parameters.size() == expectedNumberOfTypeParameters) {
                    ReferenceType keyType = parameters.get(index);
                    frame.popValue();
                    this.typesComputedFromGenerics.add(keyType);
                    GenericObjectType keySetType = GenericUtilities.getType(typeName, Collections.singletonList(keyType));
                    this.typesComputedFromGenerics.add(keySetType);
                    frame.pushValue(keySetType);
                    return true;
                }
            }
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.logError("oops", e);
        }
        return false;
    }

    public void visitInvokeInstructionCommon(InvokeInstruction obj) {
        String className;
        String signature;
        String methodName;
        TypeFrame frame;
        block46: {
            Type returnTypeOfMethod;
            frame = (TypeFrame)this.getFrame();
            methodName = obj.getMethodName(this.cpg);
            signature = obj.getSignature(this.cpg);
            className = obj.getClassName(this.cpg);
            String returnValueSignature = new SignatureParser(signature).getReturnTypeSignature();
            if (returnValueSignature.equals("V")) {
                this.consumeStack(obj);
                return;
            }
            if (methodName.equals("isInstance") && className.equals("java.lang.Class") && this.valueNumberDataflow != null) {
                try {
                    String c;
                    ValueNumber stackValue;
                    ValueNumberFrame vnaFrame = (ValueNumberFrame)this.valueNumberDataflow.getFactAtLocation(this.getLocation());
                    if (vnaFrame.isValid() && (stackValue = (ValueNumber)vnaFrame.getStackValue(1)).hasFlag(4) && (c = this.valueNumberDataflow.getClassName(stackValue)) != null) {
                        Type type;
                        if (c.charAt(0) != '[' && !c.endsWith(";")) {
                            c = "L" + c.replace('.', '/') + ";";
                        }
                        if ((type = Type.getType(c)) instanceof ReferenceType) {
                            this.instanceOfValueNumber = (ValueNumber)vnaFrame.getTopValue();
                            this.instanceOfType = (ReferenceType)type;
                            this.sawEffectiveInstanceOf = true;
                        }
                    }
                }
                catch (DataflowAnalysisException e) {
                    // empty catch block
                }
            }
            if (!((returnTypeOfMethod = obj.getType(this.cpg)) instanceof ReferenceType)) {
                this.consumeStack(obj);
                this.pushReturnType(obj);
                return;
            }
            if (methodName.equals("cast") && className.equals("java.lang.Class")) {
                try {
                    Type resultType = frame.popValue();
                    frame.popValue();
                    frame.pushValue(resultType);
                }
                catch (DataflowAnalysisException e) {
                    AnalysisContext.logError("oops", e);
                }
                return;
            }
            if (methodName.equals("get") && signature.equals("(Ljava/lang/Object;)Ljava/lang/Object;") && className.endsWith("Map") && Subtypes2.instanceOf(className, "java.util.Map") && frame.getStackDepth() >= 2) {
                try {
                    XClass xc;
                    String sourceSignature;
                    ClassDescriptor c;
                    GenericObjectType genericMapType;
                    List<? extends ReferenceType> parameters;
                    Type mapType = (Type)frame.getStackValue(1);
                    if (!(mapType instanceof GenericObjectType) || (parameters = (genericMapType = (GenericObjectType)mapType).getParameters()) == null || parameters.size() != 2 || !Subtypes2.instanceOf(c = DescriptorFactory.getClassDescriptor(genericMapType), Map.class)) break block46;
                    if (!(c.matches(Map.class) || (sourceSignature = (xc = c.getXClass()).getSourceSignature()) != null && sourceSignature.contains("Map<TK;TV;>"))) {
                        if (SystemProperties.ASSERTIONS_ENABLED) {
                            AnalysisContext.logError("QQQ: " + c + " has signature " + sourceSignature + " -- type parameters" + parameters);
                        }
                        break block46;
                    }
                    ReferenceType valueType = parameters.get(1);
                    this.consumeStack(obj);
                    frame.pushValue(valueType);
                    return;
                }
                catch (DataflowAnalysisException e) {
                    AnalysisContext.logError("oops", e);
                }
                catch (CheckedAnalysisException e) {
                    AnalysisContext.logError("oops", e);
                }
            }
        }
        if (className.equals("java.util.Map$Entry") && (methodName.equals("getKey") && this.getResultTypeFromGenericType(frame, 0, 2) || methodName.equals("getValue") && this.getResultTypeFromGenericType(frame, 1, 2))) {
            return;
        }
        if (methodName.equals("entrySet") && signature.equals("()Ljava/util/Set;") && className.startsWith("java.util") && className.endsWith("Map")) {
            GenericObjectType genericArgType;
            List<? extends ReferenceType> parameters;
            Type argType;
            try {
                argType = frame.popValue();
            }
            catch (DataflowAnalysisException e) {
                AnalysisContext.logError("oops", e);
                return;
            }
            ObjectType mapType = (ObjectType)Type.getType("Ljava/util/Map$Entry;");
            if (argType instanceof GenericObjectType && (parameters = (genericArgType = (GenericObjectType)argType).getParameters()) != null && parameters.size() == 2) {
                mapType = GenericUtilities.getType("java.util.Map$Entry", parameters);
            }
            GenericObjectType entrySetType = GenericUtilities.getType("java.util.Set", Collections.singletonList(mapType));
            frame.pushValue(entrySetType);
            return;
        }
        if (className.startsWith("java.util") && className.endsWith("Map") && (methodName.equals("keySet") && signature.equals("()Ljava/util/Set;") && this.handleGetMapView(frame, "java.util.Set", 0, 2) || methodName.equals("values") && signature.equals("()Ljava/util/Collection;") && this.handleGetMapView(frame, "java.util.Collection", 1, 2))) {
            return;
        }
        if (methodName.equals("iterator") && signature.equals("()Ljava/util/Iterator;") && className.startsWith("java.util") && this.handleGetMapView(frame, "java.util.Iterator", 0, 1)) {
            return;
        }
        if (className.equals("java.util.Iterator") && methodName.equals("next") && signature.equals("()Ljava/lang/Object;") && this.getResultTypeFromGenericType(frame, 0, 1)) {
            return;
        }
        if (methodName.equals("initCause") && signature.equals("(Ljava/lang/Throwable;)Ljava/lang/Throwable;") && className.endsWith("Exception")) {
            try {
                frame.popValue();
                return;
            }
            catch (DataflowAnalysisException e) {
                AnalysisContext.logError("Ooops", e);
            }
        }
        if (this.handleToArray(obj)) {
            return;
        }
        Type result = TopType.instance();
        try {
            Set<XMethod> targets = Hierarchy2.resolveMethodCallTargets(obj, frame, this.cpg);
            if (DEBUG) {
                System.out.println(" For call to " + className + "." + methodName + signature);
                System.out.println("   for " + targets.size() + " targets: " + targets);
            }
            for (XMethod m : targets) {
                Type t;
                Object p;
                String rv;
                XMethod m2;
                boolean foundSomething;
                block47: {
                    m = m.resolveAccessMethod();
                    String sourceSignature = m.getSourceSignature();
                    if (DEBUG) {
                        System.out.println(" Call target: " + m);
                        if (sourceSignature != null) {
                            System.out.println("  source signature: " + sourceSignature);
                        }
                    }
                    foundSomething = false;
                    m2 = m.bridgeTo();
                    if (m2 != null) {
                        m = m2;
                    }
                    if (sourceSignature != null && !sourceSignature.equals(m.getSignature()) && (rv = ((GenericSignatureParser)(p = new GenericSignatureParser(sourceSignature))).getReturnTypeSignature()).charAt(0) != 'T') {
                        try {
                            t = GenericUtilities.getType(rv);
                            if (t == null) break block47;
                            assert (t.getType() != 12);
                            result = this.merge(result, t);
                            foundSomething = true;
                        }
                        catch (RuntimeException e) {
                            AnalysisContext.logError("Problem analyzing call to " + m + " with source signature" + sourceSignature, e);
                            break;
                        }
                    }
                }
                if (m == m2) {
                    p = new SignatureParser(m.getSignature());
                    rv = ((SignatureParser)p).getReturnTypeSignature();
                    t = Type.getType(rv);
                    result = this.merge(result, t);
                    foundSomething = true;
                }
                if (foundSomething) continue;
                result = TopType.instance();
                if (DEBUG) {
                    System.out.println(" giving up");
                }
                break;
            }
        }
        catch (RuntimeException e) {
            AnalysisContext.logError("Problem analyzing call to " + className + "." + methodName + signature, e);
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.logError("Problem analyzing call to " + className + "." + methodName + signature, e);
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.logError("Problem analyzing call to " + className + "." + methodName + signature, e);
        }
        this.consumeStack(obj);
        if (result instanceof TopType) {
            this.pushReturnType(obj);
        } else {
            this.pushValue(result);
        }
    }

    private Type merge(Type prevType, Type newType) throws DataflowAnalysisException {
        if (prevType.equals(TopType.instance())) {
            if (DEBUG) {
                System.out.println("Got " + newType);
            }
            return newType;
        }
        if (prevType.equals(newType)) {
            return prevType;
        }
        Type result = this.typeMerger.mergeTypes(prevType, newType);
        if (DEBUG) {
            System.out.println("Merged " + newType + ", got " + result);
        }
        return result;
    }

    private boolean handleToArray(InvokeInstruction obj) {
        try {
            TypeFrame frame = (TypeFrame)this.getFrame();
            if (frame.getStackDepth() == 0) {
                return false;
            }
            Type topValue = (Type)frame.getTopValue();
            if (obj.getName(this.getCPG()).equals("toArray")) {
                ReferenceType target = obj.getReferenceType(this.getCPG());
                String signature = obj.getSignature(this.getCPG());
                if (signature.equals("([Ljava/lang/Object;)[Ljava/lang/Object;") && Subtypes2.isCollection(target)) {
                    boolean topIsExact = frame.isExact(frame.getStackLocation(0));
                    Type resultType = frame.popValue();
                    frame.popValue();
                    frame.pushValue(resultType);
                    frame.setExact(frame.getStackLocation(0), topIsExact);
                    return true;
                }
                if (signature.equals("()[Ljava/lang/Object;") && Subtypes2.isCollection(target) && !topValue.getSignature().equals("Ljava/util/Arrays$ArrayList;")) {
                    this.consumeStack(obj);
                    this.pushReturnType(obj);
                    frame.setExact(frame.getStackLocation(0), true);
                    return true;
                }
            }
            return false;
        }
        catch (DataflowAnalysisException e) {
            return false;
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
            return false;
        }
    }

    @CheckForNull
    GenericObjectType getLocalVariable(int index, int pos) {
        if (this.genericLocalVariables == null || !this.genericLocalVariables.get(index)) {
            return null;
        }
        for (LocalVariable local : this.localTypeTable.getLocalVariableTypeTable()) {
            String signature;
            if (local.getIndex() != index || local.getStartPC() > pos || pos >= local.getStartPC() + local.getLength() || (signature = local.getSignature()).indexOf(60) < 0) continue;
            try {
                Type t = GenericUtilities.getType(signature);
                if (t instanceof GenericObjectType) {
                    return (GenericObjectType)t;
                }
            }
            catch (RuntimeException e) {
                AnalysisContext.logError("Bad signature " + signature + " for " + local.getName(), e);
            }
            return null;
        }
        return null;
    }

    @Override
    public void handleStoreInstruction(StoreInstruction obj) {
        try {
            int numConsumed = obj.consumeStack(this.cpg);
            if (numConsumed == 1) {
                boolean isExact = this.isTopOfStackExact();
                TypeFrame frame = (TypeFrame)this.getFrame();
                Type value = frame.popValue();
                int index = obj.getIndex();
                if (value instanceof ReferenceType && !(value instanceof GenericObjectType)) {
                    GenericObjectType gType = this.getLocalVariable(index, this.getLocation().getHandle().getPosition());
                    value = GenericUtilities.merge(gType, value);
                }
                frame.setValue(index, value);
                frame.setExact(index, isExact);
            } else {
                super.handleStoreInstruction(obj);
            }
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException("error handling store instruction ", e);
        }
    }

    @Override
    public void handleLoadInstruction(LoadInstruction obj) {
        int numProduced = obj.produceStack(this.cpg);
        if (numProduced == -2) {
            throw new InvalidBytecodeException("Unpredictable stack production");
        }
        if (numProduced != 1) {
            super.handleLoadInstruction(obj);
            return;
        }
        int index = obj.getIndex();
        TypeFrame frame = (TypeFrame)this.getFrame();
        Type value = (Type)frame.getValue(index);
        if (value instanceof ReferenceType && !(value instanceof GenericObjectType)) {
            GenericObjectType gType = this.getLocalVariable(index, this.getLocation().getHandle().getPosition());
            value = GenericUtilities.merge(gType, value);
        }
        boolean isExact = frame.isExact(index);
        frame.pushValue(value);
        if (isExact) {
            this.setTopOfStackIsExact();
        }
    }

    @Override
    public void visitCHECKCAST(CHECKCAST obj) {
        try {
            Type t = ((TypeFrame)this.getFrame()).popValue();
            if (t instanceof NullType) {
                this.pushValue(t);
            } else {
                this.pushValue(obj.getType(this.getCPG()));
            }
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException("Stack underflow for " + obj + ": " + e.getMessage());
        }
    }

    @Override
    public void visitINSTANCEOF(INSTANCEOF obj) {
        if (this.valueNumberDataflow != null) {
            try {
                Type type;
                ValueNumberFrame vnaFrame = (ValueNumberFrame)this.valueNumberDataflow.getFactAtLocation(this.getLocation());
                if (vnaFrame.isValid() && (type = obj.getType(this.getCPG())) instanceof ReferenceType) {
                    this.instanceOfValueNumber = (ValueNumber)vnaFrame.getTopValue();
                    this.instanceOfType = (ReferenceType)type;
                    this.sawEffectiveInstanceOf = true;
                }
            }
            catch (DataflowAnalysisException dataflowAnalysisException) {
                // empty catch block
            }
        }
        this.consumeStack(obj);
        this.pushValue(Type.INT);
    }

    @Override
    public void visitIFNULL(IFNULL obj) {
        if (this.valueNumberDataflow != null) {
            try {
                ValueNumberFrame vnaFrame = (ValueNumberFrame)this.valueNumberDataflow.getFactAtLocation(this.getLocation());
                if (vnaFrame.isValid()) {
                    this.instanceOfValueNumber = (ValueNumber)vnaFrame.getTopValue();
                    this.instanceOfType = NullType.instance();
                    this.instanceOfFollowedByBranch = true;
                }
            }
            catch (DataflowAnalysisException dataflowAnalysisException) {
                // empty catch block
            }
        }
        this.consumeStack(obj);
    }

    @Override
    public void visitIFNONNULL(IFNONNULL obj) {
        if (this.valueNumberDataflow != null) {
            try {
                ValueNumberFrame vnaFrame = (ValueNumberFrame)this.valueNumberDataflow.getFactAtLocation(this.getLocation());
                if (vnaFrame.isValid()) {
                    this.instanceOfValueNumber = (ValueNumber)vnaFrame.getTopValue();
                    this.instanceOfType = NullType.instance();
                    this.instanceOfFollowedByBranch = true;
                }
            }
            catch (DataflowAnalysisException dataflowAnalysisException) {
                // empty catch block
            }
        }
        this.consumeStack(obj);
    }

    @Override
    public void visitFCMPL(FCMPL obj) {
        this.consumeStack(obj);
        this.pushValue(Type.INT);
    }

    @Override
    public void visitFCMPG(FCMPG obj) {
        this.consumeStack(obj);
        this.pushValue(Type.INT);
    }

    @Override
    public void visitDCMPL(DCMPL obj) {
        this.consumeStack(obj);
        this.pushValue(Type.INT);
    }

    @Override
    public void visitDCMPG(DCMPG obj) {
        this.consumeStack(obj);
        this.pushValue(Type.INT);
    }

    @Override
    public void visitLCMP(LCMP obj) {
        this.consumeStack(obj);
        this.pushValue(Type.INT);
    }

    @Override
    public void visitD2F(D2F obj) {
        this.consumeStack(obj);
        this.pushValue(Type.FLOAT);
    }

    @Override
    public void visitD2I(D2I obj) {
        this.consumeStack(obj);
        this.pushValue(Type.INT);
    }

    @Override
    public void visitD2L(D2L obj) {
        this.consumeStack(obj);
        this.pushValue(Type.LONG);
    }

    @Override
    public void visitF2D(F2D obj) {
        this.consumeStack(obj);
        this.pushValue(Type.DOUBLE);
    }

    @Override
    public void visitF2I(F2I obj) {
        this.consumeStack(obj);
        this.pushValue(Type.INT);
    }

    @Override
    public void visitF2L(F2L obj) {
        this.consumeStack(obj);
        this.pushValue(Type.LONG);
    }

    @Override
    public void visitI2B(I2B obj) {
        this.consumeStack(obj);
        this.pushValue(Type.BYTE);
    }

    @Override
    public void visitI2C(I2C obj) {
        this.consumeStack(obj);
        this.pushValue(Type.CHAR);
    }

    @Override
    public void visitI2D(I2D obj) {
        this.consumeStack(obj);
        this.pushValue(Type.DOUBLE);
    }

    @Override
    public void visitI2F(I2F obj) {
        this.consumeStack(obj);
        this.pushValue(Type.FLOAT);
    }

    @Override
    public void visitI2L(I2L obj) {
        this.consumeStack(obj);
        this.pushValue(Type.LONG);
    }

    @Override
    public void visitI2S(I2S obj) {
    }

    @Override
    public void visitL2D(L2D obj) {
        this.consumeStack(obj);
        this.pushValue(Type.DOUBLE);
    }

    @Override
    public void visitL2F(L2F obj) {
        this.consumeStack(obj);
        this.pushValue(Type.FLOAT);
    }

    @Override
    public void visitL2I(L2I obj) {
        this.consumeStack(obj);
        this.pushValue(Type.INT);
    }

    @Override
    public void visitIAND(IAND obj) {
        this.consumeStack(obj);
        this.pushValue(Type.INT);
    }

    @Override
    public void visitLAND(LAND obj) {
        this.consumeStack(obj);
        this.pushValue(Type.LONG);
    }

    @Override
    public void visitIOR(IOR obj) {
        this.consumeStack(obj);
        this.pushValue(Type.INT);
    }

    @Override
    public void visitLOR(LOR obj) {
        this.consumeStack(obj);
        this.pushValue(Type.LONG);
    }

    @Override
    public void visitIXOR(IXOR obj) {
        this.consumeStack(obj);
        this.pushValue(Type.INT);
    }

    @Override
    public void visitLXOR(LXOR obj) {
        this.consumeStack(obj);
        this.pushValue(Type.LONG);
    }

    @Override
    public void visitISHR(ISHR obj) {
        this.consumeStack(obj);
        this.pushValue(Type.INT);
    }

    @Override
    public void visitIUSHR(IUSHR obj) {
        this.consumeStack(obj);
        this.pushValue(Type.INT);
    }

    @Override
    public void visitLSHR(LSHR obj) {
        this.consumeStack(obj);
        this.pushValue(Type.LONG);
    }

    @Override
    public void visitLUSHR(LUSHR obj) {
        this.consumeStack(obj);
        this.pushValue(Type.LONG);
    }

    @Override
    public void visitISHL(ISHL obj) {
        this.consumeStack(obj);
        this.pushValue(Type.INT);
    }

    @Override
    public void visitLSHL(LSHL obj) {
        this.consumeStack(obj);
        this.pushValue(Type.LONG);
    }

    @Override
    public void visitDADD(DADD obj) {
        this.consumeStack(obj);
        this.pushValue(Type.DOUBLE);
    }

    @Override
    public void visitFADD(FADD obj) {
        this.consumeStack(obj);
        this.pushValue(Type.FLOAT);
    }

    @Override
    public void visitIADD(IADD obj) {
        this.consumeStack(obj);
        this.pushValue(Type.INT);
    }

    @Override
    public void visitLADD(LADD obj) {
        this.consumeStack(obj);
        this.pushValue(Type.LONG);
    }

    @Override
    public void visitDSUB(DSUB obj) {
        this.consumeStack(obj);
        this.pushValue(Type.DOUBLE);
    }

    @Override
    public void visitDUP(DUP obj) {
        try {
            TypeFrame frame = (TypeFrame)this.getFrame();
            boolean isExact = this.isTopOfStackExact();
            Type value = frame.popValue();
            frame.pushValue(value);
            if (isExact) {
                this.setTopOfStackIsExact();
            }
            frame.pushValue(value);
            if (isExact) {
                this.setTopOfStackIsExact();
            }
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException(e.toString());
        }
    }

    @Override
    public void visitFSUB(FSUB obj) {
        this.consumeStack(obj);
        this.pushValue(Type.FLOAT);
    }

    @Override
    public void visitISUB(ISUB obj) {
        this.consumeStack(obj);
        this.pushValue(Type.INT);
    }

    @Override
    public void visitLSUB(LSUB obj) {
        this.consumeStack(obj);
        this.pushValue(Type.LONG);
    }

    @Override
    public void visitDMUL(DMUL obj) {
        this.consumeStack(obj);
        this.pushValue(Type.DOUBLE);
    }

    @Override
    public void visitFMUL(FMUL obj) {
        this.consumeStack(obj);
        this.pushValue(Type.FLOAT);
    }

    @Override
    public void visitIMUL(IMUL obj) {
        this.consumeStack(obj);
        this.pushValue(Type.INT);
    }

    @Override
    public void visitLMUL(LMUL obj) {
        this.consumeStack(obj);
        this.pushValue(Type.LONG);
    }

    @Override
    public void visitDDIV(DDIV obj) {
        this.consumeStack(obj);
        this.pushValue(Type.DOUBLE);
    }

    @Override
    public void visitFDIV(FDIV obj) {
        this.consumeStack(obj);
        this.pushValue(Type.FLOAT);
    }

    @Override
    public void visitIDIV(IDIV obj) {
        this.consumeStack(obj);
        this.pushValue(Type.INT);
    }

    @Override
    public void visitLDIV(LDIV obj) {
        this.consumeStack(obj);
        this.pushValue(Type.LONG);
    }

    @Override
    public void visitDREM(DREM obj) {
        this.consumeStack(obj);
        this.pushValue(Type.DOUBLE);
    }

    @Override
    public void visitFREM(FREM obj) {
        this.consumeStack(obj);
        this.pushValue(Type.FLOAT);
    }

    @Override
    public void visitIREM(IREM obj) {
        this.consumeStack(obj);
        this.pushValue(Type.INT);
    }

    @Override
    public void visitLREM(LREM obj) {
        this.consumeStack(obj);
        this.pushValue(Type.LONG);
    }

    @Override
    public void visitIINC(IINC obj) {
    }

    @Override
    public void visitDNEG(DNEG obj) {
    }

    @Override
    public void visitFNEG(FNEG obj) {
    }

    @Override
    public void visitINEG(INEG obj) {
        this.consumeStack(obj);
        this.pushValue(Type.INT);
    }

    @Override
    public void visitLNEG(LNEG obj) {
    }

    @Override
    public void visitARRAYLENGTH(ARRAYLENGTH obj) {
        this.consumeStack(obj);
        this.pushValue(Type.INT);
    }

    @Override
    public void visitAALOAD(AALOAD obj) {
        TypeFrame frame = (TypeFrame)this.getFrame();
        try {
            frame.popValue();
            Type arrayType = frame.popValue();
            if (arrayType instanceof ArrayType) {
                ArrayType arr = (ArrayType)arrayType;
                this.pushValue(arr.getElementType());
            } else {
                this.pushValue(TypeFrame.getBottomType());
            }
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException("Stack underflow: " + e.getMessage());
        }
    }

    @Override
    public void visitBALOAD(BALOAD obj) {
        this.consumeStack(obj);
        this.pushValue(Type.BYTE);
    }

    @Override
    public void visitCALOAD(CALOAD obj) {
        this.consumeStack(obj);
        this.pushValue(Type.CHAR);
    }

    @Override
    public void visitDALOAD(DALOAD obj) {
        this.consumeStack(obj);
        this.pushValue(Type.DOUBLE);
    }

    @Override
    public void visitFALOAD(FALOAD obj) {
        this.consumeStack(obj);
        this.pushValue(Type.FLOAT);
    }

    @Override
    public void visitIALOAD(IALOAD obj) {
        this.consumeStack(obj);
        this.pushValue(Type.INT);
    }

    @Override
    public void visitLALOAD(LALOAD obj) {
        this.consumeStack(obj);
        this.pushValue(Type.LONG);
    }

    @Override
    public void visitSALOAD(SALOAD obj) {
        this.consumeStack(obj);
        this.pushValue(Type.SHORT);
    }

    @Override
    public void visitNEW(NEW obj) {
        this.pushValue(obj.getType(this.getCPG()));
        this.setTopOfStackIsExact();
    }

    @Override
    public void visitNEWARRAY(NEWARRAY obj) {
        this.consumeStack(obj);
        Type elementType = obj.getType();
        this.pushValue(elementType);
        this.setTopOfStackIsExact();
    }

    @Override
    public void visitANEWARRAY(ANEWARRAY obj) {
        this.consumeStack(obj);
        Type elementType = obj.getType(this.getCPG());
        this.pushValue(new ArrayType(elementType, 1));
        this.setTopOfStackIsExact();
    }

    @Override
    public void visitMULTIANEWARRAY(MULTIANEWARRAY obj) {
        this.consumeStack(obj);
        Type elementType = obj.getType(this.getCPG());
        this.pushValue(elementType);
        this.setTopOfStackIsExact();
    }

    private void setTopOfStackIsExact() {
        TypeFrame frame = (TypeFrame)this.getFrame();
        frame.setExact(frame.getNumSlots() - 1, true);
    }

    private boolean isTopOfStackExact() {
        TypeFrame frame = (TypeFrame)this.getFrame();
        return frame.isExact(frame.getNumSlots() - 1);
    }

    @Override
    public void visitJSR(JSR obj) {
        this.pushValue(ReturnaddressType.NO_TARGET);
    }

    @Override
    public void visitJSR_W(JSR_W obj) {
        this.pushValue(ReturnaddressType.NO_TARGET);
    }

    @Override
    public void visitRET(RET obj) {
    }

    @Override
    public void visitIFEQ(IFEQ obj) {
        if (this.previousWasEffectiveInstanceOf) {
            this.instanceOfFollowedByBranch = true;
        }
        super.visitIFEQ(obj);
    }

    @Override
    public void visitIFGT(IFGT obj) {
        if (this.previousWasEffectiveInstanceOf) {
            this.instanceOfFollowedByBranch = true;
        }
        super.visitIFGT(obj);
    }

    @Override
    public void visitIFLE(IFLE obj) {
        if (this.previousWasEffectiveInstanceOf) {
            this.instanceOfFollowedByBranch = true;
        }
        super.visitIFLE(obj);
    }

    @Override
    public void visitIFNE(IFNE obj) {
        if (this.previousWasEffectiveInstanceOf) {
            this.instanceOfFollowedByBranch = true;
        }
        super.visitIFNE(obj);
    }

    public boolean isImpliedByGenericTypes(ReferenceType t) {
        return this.typesComputedFromGenerics.contains(t);
    }
}

