/*
 * Decompiled with CFR 0.152.
 */
package junitx.framework;

import junitx.framework.AssertionFailedError;
import junitx.framework.ComparisonFailure;

public class Assert
extends junit.framework.Assert {
    private Assert() {
    }

    public static void assertFalse(String message, boolean condition) {
        if (condition) {
            Assert.failFalse(message);
        }
    }

    public static void assertFalse(boolean condition) {
        Assert.assertFalse(null, condition);
    }

    public static void assertEquals(String expected, String actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, String expected, String actual) {
        if (expected == null && actual == null || expected != null && expected.equals(actual)) {
            return;
        }
        throw new ComparisonFailure(message, expected, actual);
    }

    public static void assertNotEquals(String message, Object expected, Object actual) {
        if (expected == null && actual == null || expected != null && expected.equals(actual)) {
            Assert.failNotEquals(message, expected);
        }
    }

    public static void assertNotEquals(Object expected, Object actual) {
        Assert.assertNotEquals(null, expected, actual);
    }

    public static void assertNotEquals(String message, byte expected, byte actual) {
        Assert.assertNotEquals(message, new Byte(expected), new Byte(actual));
    }

    public static void assertNotEquals(byte expected, byte actual) {
        Assert.assertNotEquals(null, expected, actual);
    }

    public static void assertNotEquals(String message, char expected, char actual) {
        Assert.assertNotEquals(message, new Character(expected), new Character(actual));
    }

    public static void assertNotEquals(char expected, char actual) {
        Assert.assertNotEquals(null, expected, actual);
    }

    public static void assertNotEquals(String message, double expected, double actual, double delta) {
        if (Double.isInfinite(expected)) {
            if (expected == actual) {
                Assert.failNotEquals(message, new Double(expected));
            }
        } else if (Math.abs(expected - actual) <= delta) {
            Assert.failNotEquals(message, new Double(expected));
        }
    }

    public static void assertNotEquals(double expected, double actual, double delta) {
        Assert.assertNotEquals(null, expected, actual, delta);
    }

    public static void assertNotEquals(String message, float expected, float actual, float delta) {
        if (Float.isInfinite(expected)) {
            if (expected == actual) {
                Assert.failNotEquals(message, new Float(expected));
            }
        } else if (Math.abs(expected - actual) <= delta) {
            Assert.failNotEquals(message, new Float(expected));
        }
    }

    public static void assertNotEquals(float expected, float actual, float delta) {
        Assert.assertNotEquals(null, expected, actual, delta);
    }

    public static void assertNotEquals(String message, int expected, int actual) {
        Assert.assertNotEquals(message, new Integer(expected), new Integer(actual));
    }

    public static void assertNotEquals(int expected, int actual) {
        Assert.assertNotEquals(null, expected, actual);
    }

    public static void assertNotEquals(String message, long expected, long actual) {
        Assert.assertNotEquals(message, new Long(expected), new Long(actual));
    }

    public static void assertNotEquals(long expected, long actual) {
        Assert.assertNotEquals(null, expected, actual);
    }

    public static void assertNotEquals(String message, short expected, short actual) {
        Assert.assertNotEquals(message, new Short(expected), new Short(actual));
    }

    public static void assertNotEquals(short expected, short actual) {
        Assert.assertNotEquals(null, expected, actual);
    }

    public static void assertNotEquals(String message, boolean expected, boolean actual) {
        Assert.assertNotEquals(message, new Boolean(expected), new Boolean(actual));
    }

    public static void assertNotEquals(boolean expected, boolean actual) {
        Assert.assertNotEquals(null, expected, actual);
    }

    public static void assertNotSame(String message, Object expected, Object actual) {
        if (expected == actual) {
            Assert.failSame(message, expected);
        }
    }

    public static void assertNotSame(Object expected, Object actual) {
        Assert.assertNotSame(null, expected, actual);
    }

    private static void failFalse(String message) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        junit.framework.Assert.fail((String)(formatted + "expected <false>"));
    }

    private static void failNotEquals(String message, Object expected) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        junit.framework.Assert.fail((String)(formatted + "expected not equals to: <" + expected + ">"));
    }

    private static void failSame(String message, Object expected) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        junit.framework.Assert.fail((String)(formatted + "expected not same as: <" + expected + ">"));
    }

    public static void fail(Throwable cause) {
        Assert.fail(null, cause);
    }

    public static void fail(String message, Throwable cause) {
        throw new AssertionFailedError(message, cause);
    }
}

