// replay.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include "LogParser.h"
#include "SAXContentHandlerImpl.h"
#include <iostream>

int _tmain(int argc, _TCHAR* argv[])
{
	if (argc<2) 
	{
		wprintf(L"no argument provided\n");
		return 0;
	}

	// execute application to be replayed
	if (argc>2) {
		std::wcout << "executing " << argv[2] << std::endl;
		PROCESS_INFORMATION pi;
		STARTUPINFO si;
		ZeroMemory(&pi, sizeof(pi));
		ZeroMemory(&si, sizeof(si));
		CreateProcess(NULL, argv[2], NULL, NULL, FALSE, 0, NULL, NULL, &si, &pi);
		Sleep(10000);
	}


	// initialize COM library for the current thread
	CoInitialize(NULL); 
	MSXML2::ISAXXMLReader* pXMLReader = NULL;

	// create an instance of the XML reader
	HRESULT hr = CoCreateInstance(
		__uuidof(MSXML2::SAXXMLReader), 
		NULL, 
		CLSCTX_ALL, 
		__uuidof(MSXML2::ISAXXMLReader), 
		(void **)&pXMLReader);

	if( !FAILED(hr) ) {
		LogParser * parser = new LogParser();
		pXMLReader->putContentHandler(parser);
		hr = pXMLReader->parseURL(argv[1]);

		pXMLReader->Release();
	}

	CoUninitialize();

	getchar();

	return 0;
}

